/*
 * jQuery 1.2.6 - New Wave Javascript
 *
 * Copyright (c) 2008 John Resig (jquery.com)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * $Date: 2008-05-24 14:22:17 -0400 (Sat, 24 May 2008) $
 * $Rev: 5685 $
 */
(function(){var _jQuery=window.jQuery,_$=window.$;var jQuery=window.jQuery=window.$=function(selector,context){return new jQuery.fn.init(selector,context);};var quickExpr=/^[^<]*(<(.|\s)+>)[^>]*$|^#(\w+)$/,isSimple=/^.[^:#\[\.]*$/,undefined;jQuery.fn=jQuery.prototype={init:function(selector,context){selector=selector||document;if(selector.nodeType){this[0]=selector;this.length=1;return this;}if(typeof selector=="string"){var match=quickExpr.exec(selector);if(match&&(match[1]||!context)){if(match[1])selector=jQuery.clean([match[1]],context);else{var elem=document.getElementById(match[3]);if(elem){if(elem.id!=match[3])return jQuery().find(selector);return jQuery(elem);}selector=[];}}else
return jQuery(context).find(selector);}else if(jQuery.isFunction(selector))return jQuery(document)[jQuery.fn.ready?"ready":"load"](selector);return this.setArray(jQuery.makeArray(selector));},jquery:"1.2.6",size:function(){return this.length;},length:0,get:function(num){return num==undefined?jQuery.makeArray(this):this[num];},pushStack:function(elems){var ret=jQuery(elems);ret.prevObject=this;return ret;},setArray:function(elems){this.length=0;Array.prototype.push.apply(this,elems);return this;},each:function(callback,args){return jQuery.each(this,callback,args);},index:function(elem){var ret=-1;return jQuery.inArray(elem&&elem.jquery?elem[0]:elem,this);},attr:function(name,value,type){var options=name;if(name.constructor==String)if(value===undefined)return this[0]&&jQuery[type||"attr"](this[0],name);else{options={};options[name]=value;}return this.each(function(i){for(name in options)jQuery.attr(type?this.style:this,name,jQuery.prop(this,options[name],type,i,name));});},css:function(key,value){if((key=='width'||key=='height')&&parseFloat(value)<0)value=undefined;return this.attr(key,value,"curCSS");},text:function(text){if(typeof text!="object"&&text!=null)return this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(text));var ret="";jQuery.each(text||this,function(){jQuery.each(this.childNodes,function(){if(this.nodeType!=8)ret+=this.nodeType!=1?this.nodeValue:jQuery.fn.text([this]);});});return ret;},wrapAll:function(html){if(this[0])jQuery(html,this[0].ownerDocument).clone().insertBefore(this[0]).map(function(){var elem=this;while(elem.firstChild)elem=elem.firstChild;return elem;}).append(this);return this;},wrapInner:function(html){return this.each(function(){jQuery(this).contents().wrapAll(html);});},wrap:function(html){return this.each(function(){jQuery(this).wrapAll(html);});},append:function(){return this.domManip(arguments,true,false,function(elem){if(this.nodeType==1)this.appendChild(elem);});},prepend:function(){return this.domManip(arguments,true,true,function(elem){if(this.nodeType==1)this.insertBefore(elem,this.firstChild);});},before:function(){return this.domManip(arguments,false,false,function(elem){this.parentNode.insertBefore(elem,this);});},after:function(){return this.domManip(arguments,false,true,function(elem){this.parentNode.insertBefore(elem,this.nextSibling);});},end:function(){return this.prevObject||jQuery([]);},find:function(selector){var elems=jQuery.map(this,function(elem){return jQuery.find(selector,elem);});return this.pushStack(/[^+>] [^+>]/.test(selector)||selector.indexOf("..")>-1?jQuery.unique(elems):elems);},clone:function(events){var ret=this.map(function(){if(jQuery.browser.msie&&!jQuery.isXMLDoc(this)){var clone=this.cloneNode(true),container=document.createElement("div");container.appendChild(clone);return jQuery.clean([container.innerHTML])[0];}else
return this.cloneNode(true);});var clone=ret.find("*").andSelf().each(function(){if(this[expando]!=undefined)this[expando]=null;});if(events===true)this.find("*").andSelf().each(function(i){if(this.nodeType==3)return;var events=jQuery.data(this,"events");for(var type in events)for(var handler in events[type])jQuery.event.add(clone[i],type,events[type][handler],events[type][handler].data);});return ret;},filter:function(selector){return this.pushStack(jQuery.isFunction(selector)&&jQuery.grep(this,function(elem,i){return selector.call(elem,i);})||jQuery.multiFilter(selector,this));},not:function(selector){if(selector.constructor==String)if(isSimple.test(selector))return this.pushStack(jQuery.multiFilter(selector,this,true));else
selector=jQuery.multiFilter(selector,this);var isArrayLike=selector.length&&selector[selector.length-1]!==undefined&&!selector.nodeType;return this.filter(function(){return isArrayLike?jQuery.inArray(this,selector)<0:this!=selector;});},add:function(selector){return this.pushStack(jQuery.unique(jQuery.merge(this.get(),typeof selector=='string'?jQuery(selector):jQuery.makeArray(selector))));},is:function(selector){return!!selector&&jQuery.multiFilter(selector,this).length>0;},hasClass:function(selector){return this.is("."+selector);},val:function(value){if(value==undefined){if(this.length){var elem=this[0];if(jQuery.nodeName(elem,"select")){var index=elem.selectedIndex,values=[],options=elem.options,one=elem.type=="select-one";if(index<0)return null;for(var i=one?index:0,max=one?index+1:options.length;i<max;i++){var option=options[i];if(option.selected){value=jQuery.browser.msie&&!option.attributes.value.specified?option.text:option.value;if(one)return value;values.push(value);}}return values;}else
return(this[0].value||"").replace(/\r/g,"");}return undefined;}if(value.constructor==Number)value+='';return this.each(function(){if(this.nodeType!=1)return;if(value.constructor==Array&&/radio|checkbox/.test(this.type))this.checked=(jQuery.inArray(this.value,value)>=0||jQuery.inArray(this.name,value)>=0);else if(jQuery.nodeName(this,"select")){var values=jQuery.makeArray(value);jQuery("option",this).each(function(){this.selected=(jQuery.inArray(this.value,values)>=0||jQuery.inArray(this.text,values)>=0);});if(!values.length)this.selectedIndex=-1;}else
this.value=value;});},html:function(value){return value==undefined?(this[0]?this[0].innerHTML:null):this.empty().append(value);},replaceWith:function(value){return this.after(value).remove();},eq:function(i){return this.slice(i,i+1);},slice:function(){return this.pushStack(Array.prototype.slice.apply(this,arguments));},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem);}));},andSelf:function(){return this.add(this.prevObject);},data:function(key,value){var parts=key.split(".");parts[1]=parts[1]?"."+parts[1]:"";if(value===undefined){var data=this.triggerHandler("getData"+parts[1]+"!",[parts[0]]);if(data===undefined&&this.length)data=jQuery.data(this[0],key);return data===undefined&&parts[1]?this.data(parts[0]):data;}else
return this.trigger("setData"+parts[1]+"!",[parts[0],value]).each(function(){jQuery.data(this,key,value);});},removeData:function(key){return this.each(function(){jQuery.removeData(this,key);});},domManip:function(args,table,reverse,callback){var clone=this.length>1,elems;return this.each(function(){if(!elems){elems=jQuery.clean(args,this.ownerDocument);if(reverse)elems.reverse();}var obj=this;if(table&&jQuery.nodeName(this,"table")&&jQuery.nodeName(elems[0],"tr"))obj=this.getElementsByTagName("tbody")[0]||this.appendChild(this.ownerDocument.createElement("tbody"));var scripts=jQuery([]);jQuery.each(elems,function(){var elem=clone?jQuery(this).clone(true)[0]:this;if(jQuery.nodeName(elem,"script"))scripts=scripts.add(elem);else{if(elem.nodeType==1)scripts=scripts.add(jQuery("script",elem).remove());callback.call(obj,elem);}});scripts.each(evalScript);});}};jQuery.fn.init.prototype=jQuery.fn;function evalScript(i,elem){if(elem.src)jQuery.ajax({url:elem.src,async:false,dataType:"script"});else
jQuery.globalEval(elem.text||elem.textContent||elem.innerHTML||"");if(elem.parentNode)elem.parentNode.removeChild(elem);}function now(){return+new Date;}jQuery.extend=jQuery.fn.extend=function(){var target=arguments[0]||{},i=1,length=arguments.length,deep=false,options;if(target.constructor==Boolean){deep=target;target=arguments[1]||{};i=2;}if(typeof target!="object"&&typeof target!="function")target={};if(length==i){target=this;--i;}for(;i<length;i++)if((options=arguments[i])!=null)for(var name in options){var src=target[name],copy=options[name];if(target===copy)continue;if(deep&&copy&&typeof copy=="object"&&!copy.nodeType)target[name]=jQuery.extend(deep,src||(copy.length!=null?[]:{}),copy);else if(copy!==undefined)target[name]=copy;}return target;};var expando="jQuery"+now(),uuid=0,windowData={},exclude=/z-?index|font-?weight|opacity|zoom|line-?height/i,defaultView=document.defaultView||{};jQuery.extend({noConflict:function(deep){window.$=_$;if(deep)window.jQuery=_jQuery;return jQuery;},isFunction:function(fn){return!!fn&&typeof fn!="string"&&!fn.nodeName&&fn.constructor!=Array&&/^[\s[]?function/.test(fn+"");},isXMLDoc:function(elem){return elem.documentElement&&!elem.body||elem.tagName&&elem.ownerDocument&&!elem.ownerDocument.body;},globalEval:function(data){data=jQuery.trim(data);if(data){var head=document.getElementsByTagName("head")[0]||document.documentElement,script=document.createElement("script");script.type="text/javascript";if(jQuery.browser.msie)script.text=data;else
script.appendChild(document.createTextNode(data));head.insertBefore(script,head.firstChild);head.removeChild(script);}},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()==name.toUpperCase();},cache:{},data:function(elem,name,data){elem=elem==window?windowData:elem;var id=elem[expando];if(!id)id=elem[expando]=++uuid;if(name&&!jQuery.cache[id])jQuery.cache[id]={};if(data!==undefined)jQuery.cache[id][name]=data;return name?jQuery.cache[id][name]:id;},removeData:function(elem,name){elem=elem==window?windowData:elem;var id=elem[expando];if(name){if(jQuery.cache[id]){delete jQuery.cache[id][name];name="";for(name in jQuery.cache[id])break;if(!name)jQuery.removeData(elem);}}else{try{delete elem[expando];}catch(e){if(elem.removeAttribute)elem.removeAttribute(expando);}delete jQuery.cache[id];}},each:function(object,callback,args){var name,i=0,length=object.length;if(args){if(length==undefined){for(name in object)if(callback.apply(object[name],args)===false)break;}else
for(;i<length;)if(callback.apply(object[i++],args)===false)break;}else{if(length==undefined){for(name in object)if(callback.call(object[name],name,object[name])===false)break;}else
for(var value=object[0];i<length&&callback.call(value,i,value)!==false;value=object[++i]){}}return object;},prop:function(elem,value,type,i,name){if(jQuery.isFunction(value))value=value.call(elem,i);return value&&value.constructor==Number&&type=="curCSS"&&!exclude.test(name)?value+"px":value;},className:{add:function(elem,classNames){jQuery.each((classNames||"").split(/\s+/),function(i,className){if(elem.nodeType==1&&!jQuery.className.has(elem.className,className))elem.className+=(elem.className?" ":"")+className;});},remove:function(elem,classNames){if(elem.nodeType==1)elem.className=classNames!=undefined?jQuery.grep(elem.className.split(/\s+/),function(className){return!jQuery.className.has(classNames,className);}).join(" "):"";},has:function(elem,className){return jQuery.inArray(className,(elem.className||elem).toString().split(/\s+/))>-1;}},swap:function(elem,options,callback){var old={};for(var name in options){old[name]=elem.style[name];elem.style[name]=options[name];}callback.call(elem);for(var name in options)elem.style[name]=old[name];},css:function(elem,name,force){if(name=="width"||name=="height"){var val,props={position:"absolute",visibility:"hidden",display:"block"},which=name=="width"?["Left","Right"]:["Top","Bottom"];function getWH(){val=name=="width"?elem.offsetWidth:elem.offsetHeight;var padding=0,border=0;jQuery.each(which,function(){padding+=parseFloat(jQuery.curCSS(elem,"padding"+this,true))||0;border+=parseFloat(jQuery.curCSS(elem,"border"+this+"Width",true))||0;});val-=Math.round(padding+border);}if(jQuery(elem).is(":visible"))getWH();else
jQuery.swap(elem,props,getWH);return Math.max(0,val);}return jQuery.curCSS(elem,name,force);},curCSS:function(elem,name,force){var ret,style=elem.style;function color(elem){if(!jQuery.browser.safari)return false;var ret=defaultView.getComputedStyle(elem,null);return!ret||ret.getPropertyValue("color")=="";}if(name=="opacity"&&jQuery.browser.msie){ret=jQuery.attr(style,"opacity");return ret==""?"1":ret;}if(jQuery.browser.opera&&name=="display"){var save=style.outline;style.outline="0 solid black";style.outline=save;}if(name.match(/float/i))name=styleFloat;if(!force&&style&&style[name])ret=style[name];else if(defaultView.getComputedStyle){if(name.match(/float/i))name="float";name=name.replace(/([A-Z])/g,"-$1").toLowerCase();var computedStyle=defaultView.getComputedStyle(elem,null);if(computedStyle&&!color(elem))ret=computedStyle.getPropertyValue(name);else{var swap=[],stack=[],a=elem,i=0;for(;a&&color(a);a=a.parentNode)stack.unshift(a);for(;i<stack.length;i++)if(color(stack[i])){swap[i]=stack[i].style.display;stack[i].style.display="block";}ret=name=="display"&&swap[stack.length-1]!=null?"none":(computedStyle&&computedStyle.getPropertyValue(name))||"";for(i=0;i<swap.length;i++)if(swap[i]!=null)stack[i].style.display=swap[i];}if(name=="opacity"&&ret=="")ret="1";}else if(elem.currentStyle){var camelCase=name.replace(/\-(\w)/g,function(all,letter){return letter.toUpperCase();});ret=elem.currentStyle[name]||elem.currentStyle[camelCase];if(!/^\d+(px)?$/i.test(ret)&&/^\d/.test(ret)){var left=style.left,rsLeft=elem.runtimeStyle.left;elem.runtimeStyle.left=elem.currentStyle.left;style.left=ret||0;ret=style.pixelLeft+"px";style.left=left;elem.runtimeStyle.left=rsLeft;}}return ret;},clean:function(elems,context){var ret=[];context=context||document;if(typeof context.createElement=='undefined')context=context.ownerDocument||context[0]&&context[0].ownerDocument||document;jQuery.each(elems,function(i,elem){if(!elem)return;if(elem.constructor==Number)elem+='';if(typeof elem=="string"){elem=elem.replace(/(<(\w+)[^>]*?)\/>/g,function(all,front,tag){return tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i)?all:front+"></"+tag+">";});var tags=jQuery.trim(elem).toLowerCase(),div=context.createElement("div");var wrap=!tags.indexOf("<opt")&&[1,"<select multiple='multiple'>","</select>"]||!tags.indexOf("<leg")&&[1,"<fieldset>","</fieldset>"]||tags.match(/^<(thead|tbody|tfoot|colg|cap)/)&&[1,"<table>","</table>"]||!tags.indexOf("<tr")&&[2,"<table><tbody>","</tbody></table>"]||(!tags.indexOf("<td")||!tags.indexOf("<th"))&&[3,"<table><tbody><tr>","</tr></tbody></table>"]||!tags.indexOf("<col")&&[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"]||jQuery.browser.msie&&[1,"div<div>","</div>"]||[0,"",""];div.innerHTML=wrap[1]+elem+wrap[2];while(wrap[0]--)div=div.lastChild;if(jQuery.browser.msie){var tbody=!tags.indexOf("<table")&&tags.indexOf("<tbody")<0?div.firstChild&&div.firstChild.childNodes:wrap[1]=="<table>"&&tags.indexOf("<tbody")<0?div.childNodes:[];for(var j=tbody.length-1;j>=0;--j)if(jQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length)tbody[j].parentNode.removeChild(tbody[j]);if(/^\s/.test(elem))div.insertBefore(context.createTextNode(elem.match(/^\s*/)[0]),div.firstChild);}elem=jQuery.makeArray(div.childNodes);}if(elem.length===0&&(!jQuery.nodeName(elem,"form")&&!jQuery.nodeName(elem,"select")))return;if(elem[0]==undefined||jQuery.nodeName(elem,"form")||elem.options)ret.push(elem);else
ret=jQuery.merge(ret,elem);});return ret;},attr:function(elem,name,value){if(!elem||elem.nodeType==3||elem.nodeType==8)return undefined;var notxml=!jQuery.isXMLDoc(elem),set=value!==undefined,msie=jQuery.browser.msie;name=notxml&&jQuery.props[name]||name;if(elem.tagName){var special=/href|src|style/.test(name);if(name=="selected"&&jQuery.browser.safari)elem.parentNode.selectedIndex;if(name in elem&&notxml&&!special){if(set){if(name=="type"&&jQuery.nodeName(elem,"input")&&elem.parentNode)throw"type property can't be changed";elem[name]=value;}if(jQuery.nodeName(elem,"form")&&elem.getAttributeNode(name))return elem.getAttributeNode(name).nodeValue;return elem[name];}if(msie&&notxml&&name=="style")return jQuery.attr(elem.style,"cssText",value);if(set)elem.setAttribute(name,""+value);var attr=msie&&notxml&&special?elem.getAttribute(name,2):elem.getAttribute(name);return attr===null?undefined:attr;}if(msie&&name=="opacity"){if(set){elem.zoom=1;elem.filter=(elem.filter||"").replace(/alpha\([^)]*\)/,"")+(parseInt(value)+''=="NaN"?"":"alpha(opacity="+value*100+")");}return elem.filter&&elem.filter.indexOf("opacity=")>=0?(parseFloat(elem.filter.match(/opacity=([^)]*)/)[1])/100)+'':"";}name=name.replace(/-([a-z])/ig,function(all,letter){return letter.toUpperCase();});if(set)elem[name]=value;return elem[name];},trim:function(text){return(text||"").replace(/^\s+|\s+$/g,"");},makeArray:function(array){var ret=[];if(array!=null){var i=array.length;if(i==null||array.split||array.setInterval||array.call)ret[0]=array;else
while(i)ret[--i]=array[i];}return ret;},inArray:function(elem,array){for(var i=0,length=array.length;i<length;i++)if(array[i]===elem)return i;return-1;},merge:function(first,second){var i=0,elem,pos=first.length;if(jQuery.browser.msie){while(elem=second[i++])if(elem.nodeType!=8)first[pos++]=elem;}else
while(elem=second[i++])first[pos++]=elem;return first;},unique:function(array){var ret=[],done={};try{for(var i=0,length=array.length;i<length;i++){var id=jQuery.data(array[i]);if(!done[id]){done[id]=true;ret.push(array[i]);}}}catch(e){ret=array;}return ret;},grep:function(elems,callback,inv){var ret=[];for(var i=0,length=elems.length;i<length;i++)if(!inv!=!callback(elems[i],i))ret.push(elems[i]);return ret;},map:function(elems,callback){var ret=[];for(var i=0,length=elems.length;i<length;i++){var value=callback(elems[i],i);if(value!=null)ret[ret.length]=value;}return ret.concat.apply([],ret);}});var userAgent=navigator.userAgent.toLowerCase();jQuery.browser={version:(userAgent.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[])[1],safari:/webkit/.test(userAgent),opera:/opera/.test(userAgent),msie:/msie/.test(userAgent)&&!/opera/.test(userAgent),mozilla:/mozilla/.test(userAgent)&&!/(compatible|webkit)/.test(userAgent)};var styleFloat=jQuery.browser.msie?"styleFloat":"cssFloat";jQuery.extend({boxModel:!jQuery.browser.msie||document.compatMode=="CSS1Compat",props:{"for":"htmlFor","class":"className","float":styleFloat,cssFloat:styleFloat,styleFloat:styleFloat,readonly:"readOnly",maxlength:"maxLength",cellspacing:"cellSpacing"}});jQuery.each({parent:function(elem){return elem.parentNode;},parents:function(elem){return jQuery.dir(elem,"parentNode");},next:function(elem){return jQuery.nth(elem,2,"nextSibling");},prev:function(elem){return jQuery.nth(elem,2,"previousSibling");},nextAll:function(elem){return jQuery.dir(elem,"nextSibling");},prevAll:function(elem){return jQuery.dir(elem,"previousSibling");},siblings:function(elem){return jQuery.sibling(elem.parentNode.firstChild,elem);},children:function(elem){return jQuery.sibling(elem.firstChild);},contents:function(elem){return jQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes);}},function(name,fn){jQuery.fn[name]=function(selector){var ret=jQuery.map(this,fn);if(selector&&typeof selector=="string")ret=jQuery.multiFilter(selector,ret);return this.pushStack(jQuery.unique(ret));};});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(){var args=arguments;return this.each(function(){for(var i=0,length=args.length;i<length;i++)jQuery(args[i])[original](this);});};});jQuery.each({removeAttr:function(name){jQuery.attr(this,name,"");if(this.nodeType==1)this.removeAttribute(name);},addClass:function(classNames){jQuery.className.add(this,classNames);},removeClass:function(classNames){jQuery.className.remove(this,classNames);},toggleClass:function(classNames){jQuery.className[jQuery.className.has(this,classNames)?"remove":"add"](this,classNames);},remove:function(selector){if(!selector||jQuery.filter(selector,[this]).r.length){jQuery("*",this).add(this).each(function(){jQuery.event.remove(this);jQuery.removeData(this);});if(this.parentNode)this.parentNode.removeChild(this);}},empty:function(){jQuery(">*",this).remove();while(this.firstChild)this.removeChild(this.firstChild);}},function(name,fn){jQuery.fn[name]=function(){return this.each(fn,arguments);};});jQuery.each(["Height","Width"],function(i,name){var type=name.toLowerCase();jQuery.fn[type]=function(size){return this[0]==window?jQuery.browser.opera&&document.body["client"+name]||jQuery.browser.safari&&window["inner"+name]||document.compatMode=="CSS1Compat"&&document.documentElement["client"+name]||document.body["client"+name]:this[0]==document?Math.max(Math.max(document.body["scroll"+name],document.documentElement["scroll"+name]),Math.max(document.body["offset"+name],document.documentElement["offset"+name])):size==undefined?(this.length?jQuery.css(this[0],type):null):this.css(type,size.constructor==String?size:size+"px");};});function num(elem,prop){return elem[0]&&parseInt(jQuery.curCSS(elem[0],prop,true),10)||0;}var chars=jQuery.browser.safari&&parseInt(jQuery.browser.version)<417?"(?:[\\w*_-]|\\\\.)":"(?:[\\w\u0128-\uFFFF*_-]|\\\\.)",quickChild=new RegExp("^>\\s*("+chars+"+)"),quickID=new RegExp("^("+chars+"+)(#)("+chars+"+)"),quickClass=new RegExp("^([#.]?)("+chars+"*)");jQuery.extend({expr:{"":function(a,i,m){return m[2]=="*"||jQuery.nodeName(a,m[2]);},"#":function(a,i,m){return a.getAttribute("id")==m[2];},":":{lt:function(a,i,m){return i<m[3]-0;},gt:function(a,i,m){return i>m[3]-0;},nth:function(a,i,m){return m[3]-0==i;},eq:function(a,i,m){return m[3]-0==i;},first:function(a,i){return i==0;},last:function(a,i,m,r){return i==r.length-1;},even:function(a,i){return i%2==0;},odd:function(a,i){return i%2;},"first-child":function(a){return a.parentNode.getElementsByTagName("*")[0]==a;},"last-child":function(a){return jQuery.nth(a.parentNode.lastChild,1,"previousSibling")==a;},"only-child":function(a){return!jQuery.nth(a.parentNode.lastChild,2,"previousSibling");},parent:function(a){return a.firstChild;},empty:function(a){return!a.firstChild;},contains:function(a,i,m){return(a.textContent||a.innerText||jQuery(a).text()||"").indexOf(m[3])>=0;},visible:function(a){return"hidden"!=a.type&&jQuery.css(a,"display")!="none"&&jQuery.css(a,"visibility")!="hidden";},hidden:function(a){return"hidden"==a.type||jQuery.css(a,"display")=="none"||jQuery.css(a,"visibility")=="hidden";},enabled:function(a){return!a.disabled;},disabled:function(a){return a.disabled;},checked:function(a){return a.checked;},selected:function(a){return a.selected||jQuery.attr(a,"selected");},text:function(a){return"text"==a.type;},radio:function(a){return"radio"==a.type;},checkbox:function(a){return"checkbox"==a.type;},file:function(a){return"file"==a.type;},password:function(a){return"password"==a.type;},submit:function(a){return"submit"==a.type;},image:function(a){return"image"==a.type;},reset:function(a){return"reset"==a.type;},button:function(a){return"button"==a.type||jQuery.nodeName(a,"button");},input:function(a){return/input|select|textarea|button/i.test(a.nodeName);},has:function(a,i,m){return jQuery.find(m[3],a).length;},header:function(a){return/h\d/i.test(a.nodeName);},animated:function(a){return jQuery.grep(jQuery.timers,function(fn){return a==fn.elem;}).length;}}},parse:[/^(\[) *@?([\w-]+) *([!*$^~=]*) *('?"?)(.*?)\4 *\]/,/^(:)([\w-]+)\("?'?(.*?(\(.*?\))?[^(]*?)"?'?\)/,new RegExp("^([:.#]*)("+chars+"+)")],multiFilter:function(expr,elems,not){var old,cur=[];while(expr&&expr!=old){old=expr;var f=jQuery.filter(expr,elems,not);expr=f.t.replace(/^\s*,\s*/,"");cur=not?elems=f.r:jQuery.merge(cur,f.r);}return cur;},find:function(t,context){if(typeof t!="string")return[t];if(context&&context.nodeType!=1&&context.nodeType!=9)return[];context=context||document;var ret=[context],done=[],last,nodeName;while(t&&last!=t){var r=[];last=t;t=jQuery.trim(t);var foundToken=false,re=quickChild,m=re.exec(t);if(m){nodeName=m[1].toUpperCase();for(var i=0;ret[i];i++)for(var c=ret[i].firstChild;c;c=c.nextSibling)if(c.nodeType==1&&(nodeName=="*"||c.nodeName.toUpperCase()==nodeName))r.push(c);ret=r;t=t.replace(re,"");if(t.indexOf(" ")==0)continue;foundToken=true;}else{re=/^([>+~])\s*(\w*)/i;if((m=re.exec(t))!=null){r=[];var merge={};nodeName=m[2].toUpperCase();m=m[1];for(var j=0,rl=ret.length;j<rl;j++){var n=m=="~"||m=="+"?ret[j].nextSibling:ret[j].firstChild;for(;n;n=n.nextSibling)if(n.nodeType==1){var id=jQuery.data(n);if(m=="~"&&merge[id])break;if(!nodeName||n.nodeName.toUpperCase()==nodeName){if(m=="~")merge[id]=true;r.push(n);}if(m=="+")break;}}ret=r;t=jQuery.trim(t.replace(re,""));foundToken=true;}}if(t&&!foundToken){if(!t.indexOf(",")){if(context==ret[0])ret.shift();done=jQuery.merge(done,ret);r=ret=[context];t=" "+t.substr(1,t.length);}else{var re2=quickID;var m=re2.exec(t);if(m){m=[0,m[2],m[3],m[1]];}else{re2=quickClass;m=re2.exec(t);}m[2]=m[2].replace(/\\/g,"");var elem=ret[ret.length-1];if(m[1]=="#"&&elem&&elem.getElementById&&!jQuery.isXMLDoc(elem)){var oid=elem.getElementById(m[2]);if((jQuery.browser.msie||jQuery.browser.opera)&&oid&&typeof oid.id=="string"&&oid.id!=m[2])oid=jQuery('[@id="'+m[2]+'"]',elem)[0];ret=r=oid&&(!m[3]||jQuery.nodeName(oid,m[3]))?[oid]:[];}else{for(var i=0;ret[i];i++){var tag=m[1]=="#"&&m[3]?m[3]:m[1]!=""||m[0]==""?"*":m[2];if(tag=="*"&&ret[i].nodeName.toLowerCase()=="object")tag="param";r=jQuery.merge(r,ret[i].getElementsByTagName(tag));}if(m[1]==".")r=jQuery.classFilter(r,m[2]);if(m[1]=="#"){var tmp=[];for(var i=0;r[i];i++)if(r[i].getAttribute("id")==m[2]){tmp=[r[i]];break;}r=tmp;}ret=r;}t=t.replace(re2,"");}}if(t){var val=jQuery.filter(t,r);ret=r=val.r;t=jQuery.trim(val.t);}}if(t)ret=[];if(ret&&context==ret[0])ret.shift();done=jQuery.merge(done,ret);return done;},classFilter:function(r,m,not){m=" "+m+" ";var tmp=[];for(var i=0;r[i];i++){var pass=(" "+r[i].className+" ").indexOf(m)>=0;if(!not&&pass||not&&!pass)tmp.push(r[i]);}return tmp;},filter:function(t,r,not){var last;while(t&&t!=last){last=t;var p=jQuery.parse,m;for(var i=0;p[i];i++){m=p[i].exec(t);if(m){t=t.substring(m[0].length);m[2]=m[2].replace(/\\/g,"");break;}}if(!m)break;if(m[1]==":"&&m[2]=="not")r=isSimple.test(m[3])?jQuery.filter(m[3],r,true).r:jQuery(r).not(m[3]);else if(m[1]==".")r=jQuery.classFilter(r,m[2],not);else if(m[1]=="["){var tmp=[],type=m[3];for(var i=0,rl=r.length;i<rl;i++){var a=r[i],z=a[jQuery.props[m[2]]||m[2]];if(z==null||/href|src|selected/.test(m[2]))z=jQuery.attr(a,m[2])||'';if((type==""&&!!z||type=="="&&z==m[5]||type=="!="&&z!=m[5]||type=="^="&&z&&!z.indexOf(m[5])||type=="$="&&z.substr(z.length-m[5].length)==m[5]||(type=="*="||type=="~=")&&z.indexOf(m[5])>=0)^not)tmp.push(a);}r=tmp;}else if(m[1]==":"&&m[2]=="nth-child"){var merge={},tmp=[],test=/(-?)(\d*)n((?:\+|-)?\d*)/.exec(m[3]=="even"&&"2n"||m[3]=="odd"&&"2n+1"||!/\D/.test(m[3])&&"0n+"+m[3]||m[3]),first=(test[1]+(test[2]||1))-0,last=test[3]-0;for(var i=0,rl=r.length;i<rl;i++){var node=r[i],parentNode=node.parentNode,id=jQuery.data(parentNode);if(!merge[id]){var c=1;for(var n=parentNode.firstChild;n;n=n.nextSibling)if(n.nodeType==1)n.nodeIndex=c++;merge[id]=true;}var add=false;if(first==0){if(node.nodeIndex==last)add=true;}else if((node.nodeIndex-last)%first==0&&(node.nodeIndex-last)/first>=0)add=true;if(add^not)tmp.push(node);}r=tmp;}else{var fn=jQuery.expr[m[1]];if(typeof fn=="object")fn=fn[m[2]];if(typeof fn=="string")fn=eval("false||function(a,i){return "+fn+";}");r=jQuery.grep(r,function(elem,i){return fn(elem,i,m,r);},not);}}return{r:r,t:t};},dir:function(elem,dir){var matched=[],cur=elem[dir];while(cur&&cur!=document){if(cur.nodeType==1)matched.push(cur);cur=cur[dir];}return matched;},nth:function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir])if(cur.nodeType==1&&++num==result)break;return cur;},sibling:function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType==1&&n!=elem)r.push(n);}return r;}});jQuery.event={add:function(elem,types,handler,data){if(elem.nodeType==3||elem.nodeType==8)return;if(jQuery.browser.msie&&elem.setInterval)elem=window;if(!handler.guid)handler.guid=this.guid++;if(data!=undefined){var fn=handler;handler=this.proxy(fn,function(){return fn.apply(this,arguments);});handler.data=data;}var events=jQuery.data(elem,"events")||jQuery.data(elem,"events",{}),handle=jQuery.data(elem,"handle")||jQuery.data(elem,"handle",function(){if(typeof jQuery!="undefined"&&!jQuery.event.triggered)return jQuery.event.handle.apply(arguments.callee.elem,arguments);});handle.elem=elem;jQuery.each(types.split(/\s+/),function(index,type){var parts=type.split(".");type=parts[0];handler.type=parts[1];var handlers=events[type];if(!handlers){handlers=events[type]={};if(!jQuery.event.special[type]||jQuery.event.special[type].setup.call(elem)===false){if(elem.addEventListener)elem.addEventListener(type,handle,false);else if(elem.attachEvent)elem.attachEvent("on"+type,handle);}}handlers[handler.guid]=handler;jQuery.event.global[type]=true;});elem=null;},guid:1,global:{},remove:function(elem,types,handler){if(elem.nodeType==3||elem.nodeType==8)return;var events=jQuery.data(elem,"events"),ret,index;if(events){if(types==undefined||(typeof types=="string"&&types.charAt(0)=="."))for(var type in events)this.remove(elem,type+(types||""));else{if(types.type){handler=types.handler;types=types.type;}jQuery.each(types.split(/\s+/),function(index,type){var parts=type.split(".");type=parts[0];if(events[type]){if(handler)delete events[type][handler.guid];else
for(handler in events[type])if(!parts[1]||events[type][handler].type==parts[1])delete events[type][handler];for(ret in events[type])break;if(!ret){if(!jQuery.event.special[type]||jQuery.event.special[type].teardown.call(elem)===false){if(elem.removeEventListener)elem.removeEventListener(type,jQuery.data(elem,"handle"),false);else if(elem.detachEvent)elem.detachEvent("on"+type,jQuery.data(elem,"handle"));}ret=null;delete events[type];}}});}for(ret in events)break;if(!ret){var handle=jQuery.data(elem,"handle");if(handle)handle.elem=null;jQuery.removeData(elem,"events");jQuery.removeData(elem,"handle");}}},trigger:function(type,data,elem,donative,extra){data=jQuery.makeArray(data);if(type.indexOf("!")>=0){type=type.slice(0,-1);var exclusive=true;}if(!elem){if(this.global[type])jQuery("*").add([window,document]).trigger(type,data);}else{if(elem.nodeType==3||elem.nodeType==8)return undefined;var val,ret,fn=jQuery.isFunction(elem[type]||null),event=!data[0]||!data[0].preventDefault;if(event){data.unshift({type:type,target:elem,preventDefault:function(){},stopPropagation:function(){},timeStamp:now()});data[0][expando]=true;}data[0].type=type;if(exclusive)data[0].exclusive=true;var handle=jQuery.data(elem,"handle");if(handle)val=handle.apply(elem,data);if((!fn||(jQuery.nodeName(elem,'a')&&type=="click"))&&elem["on"+type]&&elem["on"+type].apply(elem,data)===false)val=false;if(event)data.shift();if(extra&&jQuery.isFunction(extra)){ret=extra.apply(elem,val==null?data:data.concat(val));if(ret!==undefined)val=ret;}if(fn&&donative!==false&&val!==false&&!(jQuery.nodeName(elem,'a')&&type=="click")){this.triggered=true;try{elem[type]();}catch(e){}}this.triggered=false;}return val;},handle:function(event){var val,ret,namespace,all,handlers;event=arguments[0]=jQuery.event.fix(event||window.event);namespace=event.type.split(".");event.type=namespace[0];namespace=namespace[1];all=!namespace&&!event.exclusive;handlers=(jQuery.data(this,"events")||{})[event.type];for(var j in handlers){var handler=handlers[j];if(all||handler.type==namespace){event.handler=handler;event.data=handler.data;ret=handler.apply(this,arguments);if(val!==false)val=ret;if(ret===false){event.preventDefault();event.stopPropagation();}}}return val;},fix:function(event){if(event[expando]==true)return event;var originalEvent=event;event={originalEvent:originalEvent};var props="altKey attrChange attrName bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase fromElement handler keyCode metaKey newValue originalTarget pageX pageY prevValue relatedNode relatedTarget screenX screenY shiftKey srcElement target timeStamp toElement type view wheelDelta which".split(" ");for(var i=props.length;i;i--)event[props[i]]=originalEvent[props[i]];event[expando]=true;event.preventDefault=function(){if(originalEvent.preventDefault)originalEvent.preventDefault();originalEvent.returnValue=false;};event.stopPropagation=function(){if(originalEvent.stopPropagation)originalEvent.stopPropagation();originalEvent.cancelBubble=true;};event.timeStamp=event.timeStamp||now();if(!event.target)event.target=event.srcElement||document;if(event.target.nodeType==3)event.target=event.target.parentNode;if(!event.relatedTarget&&event.fromElement)event.relatedTarget=event.fromElement==event.target?event.toElement:event.fromElement;if(event.pageX==null&&event.clientX!=null){var doc=document.documentElement,body=document.body;event.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc.clientLeft||0);event.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc.clientTop||0);}if(!event.which&&((event.charCode||event.charCode===0)?event.charCode:event.keyCode))event.which=event.charCode||event.keyCode;if(!event.metaKey&&event.ctrlKey)event.metaKey=event.ctrlKey;if(!event.which&&event.button)event.which=(event.button&1?1:(event.button&2?3:(event.button&4?2:0)));return event;},proxy:function(fn,proxy){proxy.guid=fn.guid=fn.guid||proxy.guid||this.guid++;return proxy;},special:{ready:{setup:function(){bindReady();return;},teardown:function(){return;}},mouseenter:{setup:function(){if(jQuery.browser.msie)return false;jQuery(this).bind("mouseover",jQuery.event.special.mouseenter.handler);return true;},teardown:function(){if(jQuery.browser.msie)return false;jQuery(this).unbind("mouseover",jQuery.event.special.mouseenter.handler);return true;},handler:function(event){if(withinElement(event,this))return true;event.type="mouseenter";return jQuery.event.handle.apply(this,arguments);}},mouseleave:{setup:function(){if(jQuery.browser.msie)return false;jQuery(this).bind("mouseout",jQuery.event.special.mouseleave.handler);return true;},teardown:function(){if(jQuery.browser.msie)return false;jQuery(this).unbind("mouseout",jQuery.event.special.mouseleave.handler);return true;},handler:function(event){if(withinElement(event,this))return true;event.type="mouseleave";return jQuery.event.handle.apply(this,arguments);}}}};jQuery.fn.extend({bind:function(type,data,fn){return type=="unload"?this.one(type,data,fn):this.each(function(){jQuery.event.add(this,type,fn||data,fn&&data);});},one:function(type,data,fn){var one=jQuery.event.proxy(fn||data,function(event){jQuery(this).unbind(event,one);return(fn||data).apply(this,arguments);});return this.each(function(){jQuery.event.add(this,type,one,fn&&data);});},unbind:function(type,fn){return this.each(function(){jQuery.event.remove(this,type,fn);});},trigger:function(type,data,fn){return this.each(function(){jQuery.event.trigger(type,data,this,true,fn);});},triggerHandler:function(type,data,fn){return this[0]&&jQuery.event.trigger(type,data,this[0],false,fn);},toggle:function(fn){var args=arguments,i=1;while(i<args.length)jQuery.event.proxy(fn,args[i++]);return this.click(jQuery.event.proxy(fn,function(event){this.lastToggle=(this.lastToggle||0)%i;event.preventDefault();return args[this.lastToggle++].apply(this,arguments)||false;}));},hover:function(fnOver,fnOut){return this.bind('mouseenter',fnOver).bind('mouseleave',fnOut);},ready:function(fn){bindReady();if(jQuery.isReady)fn.call(document,jQuery);else
jQuery.readyList.push(function(){return fn.call(this,jQuery);});return this;}});jQuery.extend({isReady:false,readyList:[],ready:function(){if(!jQuery.isReady){jQuery.isReady=true;if(jQuery.readyList){jQuery.each(jQuery.readyList,function(){this.call(document);});jQuery.readyList=null;}jQuery(document).triggerHandler("ready");}}});var readyBound=false;function bindReady(){if(readyBound)return;readyBound=true;if(document.addEventListener&&!jQuery.browser.opera)document.addEventListener("DOMContentLoaded",jQuery.ready,false);if(jQuery.browser.msie&&window==top)(function(){if(jQuery.isReady)return;try{document.documentElement.doScroll("left");}catch(error){setTimeout(arguments.callee,0);return;}jQuery.ready();})();if(jQuery.browser.opera)document.addEventListener("DOMContentLoaded",function(){if(jQuery.isReady)return;for(var i=0;i<document.styleSheets.length;i++)if(document.styleSheets[i].disabled){setTimeout(arguments.callee,0);return;}jQuery.ready();},false);if(jQuery.browser.safari){var numStyles;(function(){if(jQuery.isReady)return;if(document.readyState!="loaded"&&document.readyState!="complete"){setTimeout(arguments.callee,0);return;}if(numStyles===undefined)numStyles=jQuery("style, link[rel=stylesheet]").length;if(document.styleSheets.length!=numStyles){setTimeout(arguments.callee,0);return;}jQuery.ready();})();}jQuery.event.add(window,"load",jQuery.ready);}jQuery.each(("blur,focus,load,resize,scroll,unload,click,dblclick,"+"mousedown,mouseup,mousemove,mouseover,mouseout,change,select,"+"submit,keydown,keypress,keyup,error").split(","),function(i,name){jQuery.fn[name]=function(fn){return fn?this.bind(name,fn):this.trigger(name);};});var withinElement=function(event,elem){var parent=event.relatedTarget;while(parent&&parent!=elem)try{parent=parent.parentNode;}catch(error){parent=elem;}return parent==elem;};jQuery(window).bind("unload",function(){jQuery("*").add(document).unbind();});jQuery.fn.extend({_load:jQuery.fn.load,load:function(url,params,callback){if(typeof url!='string')return this._load(url);var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off);}callback=callback||function(){};var type="GET";if(params)if(jQuery.isFunction(params)){callback=params;params=null;}else{params=jQuery.param(params);type="POST";}var self=this;jQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(res,status){if(status=="success"||status=="notmodified")self.html(selector?jQuery("<div/>").append(res.responseText.replace(/<script(.|\s)*?\/script>/g,"")).find(selector):res.responseText);self.each(callback,[res.responseText,status,res]);}});return this;},serialize:function(){return jQuery.param(this.serializeArray());},serializeArray:function(){return this.map(function(){return jQuery.nodeName(this,"form")?jQuery.makeArray(this.elements):this;}).filter(function(){return this.name&&!this.disabled&&(this.checked||/select|textarea/i.test(this.nodeName)||/text|hidden|password/i.test(this.type));}).map(function(i,elem){var val=jQuery(this).val();return val==null?null:val.constructor==Array?jQuery.map(val,function(val,i){return{name:elem.name,value:val};}):{name:elem.name,value:val};}).get();}});jQuery.each("ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend".split(","),function(i,o){jQuery.fn[o]=function(f){return this.bind(o,f);};});var jsc=now();jQuery.extend({get:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data=null;}return jQuery.ajax({type:"GET",url:url,data:data,success:callback,dataType:type});},getScript:function(url,callback){return jQuery.get(url,null,callback,"script");},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json");},post:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data={};}return jQuery.ajax({type:"POST",url:url,data:data,success:callback,dataType:type});},ajaxSetup:function(settings){jQuery.extend(jQuery.ajaxSettings,settings);},ajaxSettings:{url:location.href,global:true,type:"GET",timeout:0,contentType:"application/x-www-form-urlencoded",processData:true,async:true,data:null,username:null,password:null,accepts:{xml:"application/xml, text/xml",html:"text/html",script:"text/javascript, application/javascript",json:"application/json, text/javascript",text:"text/plain",_default:"*/*"}},lastModified:{},ajax:function(s){s=jQuery.extend(true,s,jQuery.extend(true,{},jQuery.ajaxSettings,s));var jsonp,jsre=/=\?(&|$)/g,status,data,type=s.type.toUpperCase();if(s.data&&s.processData&&typeof s.data!="string")s.data=jQuery.param(s.data);if(s.dataType=="jsonp"){if(type=="GET"){if(!s.url.match(jsre))s.url+=(s.url.match(/\?/)?"&":"?")+(s.jsonp||"callback")+"=?";}else if(!s.data||!s.data.match(jsre))s.data=(s.data?s.data+"&":"")+(s.jsonp||"callback")+"=?";s.dataType="json";}if(s.dataType=="json"&&(s.data&&s.data.match(jsre)||s.url.match(jsre))){jsonp="jsonp"+jsc++;if(s.data)s.data=(s.data+"").replace(jsre,"="+jsonp+"$1");s.url=s.url.replace(jsre,"="+jsonp+"$1");s.dataType="script";window[jsonp]=function(tmp){data=tmp;success();complete();window[jsonp]=undefined;try{delete window[jsonp];}catch(e){}if(head)head.removeChild(script);};}if(s.dataType=="script"&&s.cache==null)s.cache=false;if(s.cache===false&&type=="GET"){var ts=now();var ret=s.url.replace(/(\?|&)_=.*?(&|$)/,"$1_="+ts+"$2");s.url=ret+((ret==s.url)?(s.url.match(/\?/)?"&":"?")+"_="+ts:"");}if(s.data&&type=="GET"){s.url+=(s.url.match(/\?/)?"&":"?")+s.data;s.data=null;}if(s.global&&!jQuery.active++)jQuery.event.trigger("ajaxStart");var remote=/^(?:\w+:)?\/\/([^\/?#]+)/;if(s.dataType=="script"&&type=="GET"&&remote.test(s.url)&&remote.exec(s.url)[1]!=location.host){var head=document.getElementsByTagName("head")[0];var script=document.createElement("script");script.src=s.url;if(s.scriptCharset)script.charset=s.scriptCharset;if(!jsonp){var done=false;script.onload=script.onreadystatechange=function(){if(!done&&(!this.readyState||this.readyState=="loaded"||this.readyState=="complete")){done=true;success();complete();head.removeChild(script);}};}head.appendChild(script);return undefined;}var requestDone=false;var xhr=window.ActiveXObject?new ActiveXObject("Microsoft.XMLHTTP"):new XMLHttpRequest();if(s.username)xhr.open(type,s.url,s.async,s.username,s.password);else
xhr.open(type,s.url,s.async);try{if(s.data)xhr.setRequestHeader("Content-Type",s.contentType);if(s.ifModified)xhr.setRequestHeader("If-Modified-Since",jQuery.lastModified[s.url]||"Thu, 01 Jan 1970 00:00:00 GMT");xhr.setRequestHeader("X-Requested-With","XMLHttpRequest");xhr.setRequestHeader("Accept",s.dataType&&s.accepts[s.dataType]?s.accepts[s.dataType]+", */*":s.accepts._default);}catch(e){}if(s.beforeSend&&s.beforeSend(xhr,s)===false){s.global&&jQuery.active--;xhr.abort();return false;}if(s.global)jQuery.event.trigger("ajaxSend",[xhr,s]);var onreadystatechange=function(isTimeout){if(!requestDone&&xhr&&(xhr.readyState==4||isTimeout=="timeout")){requestDone=true;if(ival){clearInterval(ival);ival=null;}status=isTimeout=="timeout"&&"timeout"||!jQuery.httpSuccess(xhr)&&"error"||s.ifModified&&jQuery.httpNotModified(xhr,s.url)&&"notmodified"||"success";if(status=="success"){try{data=jQuery.httpData(xhr,s.dataType,s.dataFilter);}catch(e){status="parsererror";}}if(status=="success"){var modRes;try{modRes=xhr.getResponseHeader("Last-Modified");}catch(e){}if(s.ifModified&&modRes)jQuery.lastModified[s.url]=modRes;if(!jsonp)success();}else
jQuery.handleError(s,xhr,status);complete();if(s.async)xhr=null;}};if(s.async){var ival=setInterval(onreadystatechange,13);if(s.timeout>0)setTimeout(function(){if(xhr){xhr.abort();if(!requestDone)onreadystatechange("timeout");}},s.timeout);}try{xhr.send(s.data);}catch(e){jQuery.handleError(s,xhr,null,e);}if(!s.async)onreadystatechange();function success(){if(s.success)s.success(data,status);if(s.global)jQuery.event.trigger("ajaxSuccess",[xhr,s]);}function complete(){if(s.complete)s.complete(xhr,status);if(s.global)jQuery.event.trigger("ajaxComplete",[xhr,s]);if(s.global&&!--jQuery.active)jQuery.event.trigger("ajaxStop");}return xhr;},handleError:function(s,xhr,status,e){if(s.error)s.error(xhr,status,e);if(s.global)jQuery.event.trigger("ajaxError",[xhr,s,e]);},active:0,httpSuccess:function(xhr){try{return!xhr.status&&location.protocol=="file:"||(xhr.status>=200&&xhr.status<300)||xhr.status==304||xhr.status==1223||jQuery.browser.safari&&xhr.status==undefined;}catch(e){}return false;},httpNotModified:function(xhr,url){try{var xhrRes=xhr.getResponseHeader("Last-Modified");return xhr.status==304||xhrRes==jQuery.lastModified[url]||jQuery.browser.safari&&xhr.status==undefined;}catch(e){}return false;},httpData:function(xhr,type,filter){var ct=xhr.getResponseHeader("content-type"),xml=type=="xml"||!type&&ct&&ct.indexOf("xml")>=0,data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.tagName=="parsererror")throw"parsererror";if(filter)data=filter(data,type);if(type=="script")jQuery.globalEval(data);if(type=="json")data=eval("("+data+")");return data;},param:function(a){var s=[];if(a.constructor==Array||a.jquery)jQuery.each(a,function(){s.push(encodeURIComponent(this.name)+"="+encodeURIComponent(this.value));});else
for(var j in a)if(a[j]&&a[j].constructor==Array)jQuery.each(a[j],function(){s.push(encodeURIComponent(j)+"="+encodeURIComponent(this));});else
s.push(encodeURIComponent(j)+"="+encodeURIComponent(jQuery.isFunction(a[j])?a[j]():a[j]));return s.join("&").replace(/%20/g,"+");}});jQuery.fn.extend({show:function(speed,callback){return speed?this.animate({height:"show",width:"show",opacity:"show"},speed,callback):this.filter(":hidden").each(function(){this.style.display=this.oldblock||"";if(jQuery.css(this,"display")=="none"){var elem=jQuery("<"+this.tagName+" />").appendTo("body");this.style.display=elem.css("display");if(this.style.display=="none")this.style.display="block";elem.remove();}}).end();},hide:function(speed,callback){return speed?this.animate({height:"hide",width:"hide",opacity:"hide"},speed,callback):this.filter(":visible").each(function(){this.oldblock=this.oldblock||jQuery.css(this,"display");this.style.display="none";}).end();},_toggle:jQuery.fn.toggle,toggle:function(fn,fn2){return jQuery.isFunction(fn)&&jQuery.isFunction(fn2)?this._toggle.apply(this,arguments):fn?this.animate({height:"toggle",width:"toggle",opacity:"toggle"},fn,fn2):this.each(function(){jQuery(this)[jQuery(this).is(":hidden")?"show":"hide"]();});},slideDown:function(speed,callback){return this.animate({height:"show"},speed,callback);},slideUp:function(speed,callback){return this.animate({height:"hide"},speed,callback);},slideToggle:function(speed,callback){return this.animate({height:"toggle"},speed,callback);},fadeIn:function(speed,callback){return this.animate({opacity:"show"},speed,callback);},fadeOut:function(speed,callback){return this.animate({opacity:"hide"},speed,callback);},fadeTo:function(speed,to,callback){return this.animate({opacity:to},speed,callback);},animate:function(prop,speed,easing,callback){var optall=jQuery.speed(speed,easing,callback);return this[optall.queue===false?"each":"queue"](function(){if(this.nodeType!=1)return false;var opt=jQuery.extend({},optall),p,hidden=jQuery(this).is(":hidden"),self=this;for(p in prop){if(prop[p]=="hide"&&hidden||prop[p]=="show"&&!hidden)return opt.complete.call(this);if(p=="height"||p=="width"){opt.display=jQuery.css(this,"display");opt.overflow=this.style.overflow;}}if(opt.overflow!=null)this.style.overflow="hidden";opt.curAnim=jQuery.extend({},prop);jQuery.each(prop,function(name,val){var e=new jQuery.fx(self,opt,name);if(/toggle|show|hide/.test(val))e[val=="toggle"?hidden?"show":"hide":val](prop);else{var parts=val.toString().match(/^([+-]=)?([\d+-.]+)(.*)$/),start=e.cur(true)||0;if(parts){var end=parseFloat(parts[2]),unit=parts[3]||"px";if(unit!="px"){self.style[name]=(end||1)+unit;start=((end||1)/e.cur(true))*start;self.style[name]=start+unit;}if(parts[1])end=((parts[1]=="-="?-1:1)*end)+start;e.custom(start,end,unit);}else
e.custom(start,val,"");}});return true;});},queue:function(type,fn){if(jQuery.isFunction(type)||(type&&type.constructor==Array)){fn=type;type="fx";}if(!type||(typeof type=="string"&&!fn))return queue(this[0],type);return this.each(function(){if(fn.constructor==Array)queue(this,type,fn);else{queue(this,type).push(fn);if(queue(this,type).length==1)fn.call(this);}});},stop:function(clearQueue,gotoEnd){var timers=jQuery.timers;if(clearQueue)this.queue([]);this.each(function(){for(var i=timers.length-1;i>=0;i--)if(timers[i].elem==this){if(gotoEnd)timers[i](true);timers.splice(i,1);}});if(!gotoEnd)this.dequeue();return this;}});var queue=function(elem,type,array){if(elem){type=type||"fx";var q=jQuery.data(elem,type+"queue");if(!q||array)q=jQuery.data(elem,type+"queue",jQuery.makeArray(array));}return q;};jQuery.fn.dequeue=function(type){type=type||"fx";return this.each(function(){var q=queue(this,type);q.shift();if(q.length)q[0].call(this);});};jQuery.extend({speed:function(speed,easing,fn){var opt=speed&&speed.constructor==Object?speed:{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&easing.constructor!=Function&&easing};opt.duration=(opt.duration&&opt.duration.constructor==Number?opt.duration:jQuery.fx.speeds[opt.duration])||jQuery.fx.speeds.def;opt.old=opt.complete;opt.complete=function(){if(opt.queue!==false)jQuery(this).dequeue();if(jQuery.isFunction(opt.old))opt.old.call(this);};return opt;},easing:{linear:function(p,n,firstNum,diff){return firstNum+diff*p;},swing:function(p,n,firstNum,diff){return((-Math.cos(p*Math.PI)/2)+0.5)*diff+firstNum;}},timers:[],timerId:null,fx:function(elem,options,prop){this.options=options;this.elem=elem;this.prop=prop;if(!options.orig)options.orig={};}});jQuery.fx.prototype={update:function(){if(this.options.step)this.options.step.call(this.elem,this.now,this);(jQuery.fx.step[this.prop]||jQuery.fx.step._default)(this);if(this.prop=="height"||this.prop=="width")this.elem.style.display="block";},cur:function(force){if(this.elem[this.prop]!=null&&this.elem.style[this.prop]==null)return this.elem[this.prop];var r=parseFloat(jQuery.css(this.elem,this.prop,force));return r&&r>-10000?r:parseFloat(jQuery.curCSS(this.elem,this.prop))||0;},custom:function(from,to,unit){this.startTime=now();this.start=from;this.end=to;this.unit=unit||this.unit||"px";this.now=this.start;this.pos=this.state=0;this.update();var self=this;function t(gotoEnd){return self.step(gotoEnd);}t.elem=this.elem;jQuery.timers.push(t);if(jQuery.timerId==null){jQuery.timerId=setInterval(function(){var timers=jQuery.timers;for(var i=0;i<timers.length;i++)if(!timers[i]())timers.splice(i--,1);if(!timers.length){clearInterval(jQuery.timerId);jQuery.timerId=null;}},13);}},show:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.show=true;this.custom(0,this.cur());if(this.prop=="width"||this.prop=="height")this.elem.style[this.prop]="1px";jQuery(this.elem).show();},hide:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.hide=true;this.custom(this.cur(),0);},step:function(gotoEnd){var t=now();if(gotoEnd||t>this.options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();this.options.curAnim[this.prop]=true;var done=true;for(var i in this.options.curAnim)if(this.options.curAnim[i]!==true)done=false;if(done){if(this.options.display!=null){this.elem.style.overflow=this.options.overflow;this.elem.style.display=this.options.display;if(jQuery.css(this.elem,"display")=="none")this.elem.style.display="block";}if(this.options.hide)this.elem.style.display="none";if(this.options.hide||this.options.show)for(var p in this.options.curAnim)jQuery.attr(this.elem.style,p,this.options.orig[p]);}if(done)this.options.complete.call(this.elem);return false;}else{var n=t-this.startTime;this.state=n/this.options.duration;this.pos=jQuery.easing[this.options.easing||(jQuery.easing.swing?"swing":"linear")](this.state,n,0,1,this.options.duration);this.now=this.start+((this.end-this.start)*this.pos);this.update();}return true;}};jQuery.extend(jQuery.fx,{speeds:{slow:600,fast:200,def:400},step:{scrollLeft:function(fx){fx.elem.scrollLeft=fx.now;},scrollTop:function(fx){fx.elem.scrollTop=fx.now;},opacity:function(fx){jQuery.attr(fx.elem.style,"opacity",fx.now);},_default:function(fx){fx.elem.style[fx.prop]=fx.now+fx.unit;}}});jQuery.fn.offset=function(){var left=0,top=0,elem=this[0],results;if(elem)with(jQuery.browser){var parent=elem.parentNode,offsetChild=elem,offsetParent=elem.offsetParent,doc=elem.ownerDocument,safari2=safari&&parseInt(version)<522&&!/adobeair/i.test(userAgent),css=jQuery.curCSS,fixed=css(elem,"position")=="fixed";if(elem.getBoundingClientRect){var box=elem.getBoundingClientRect();add(box.left+Math.max(doc.documentElement.scrollLeft,doc.body.scrollLeft),box.top+Math.max(doc.documentElement.scrollTop,doc.body.scrollTop));add(-doc.documentElement.clientLeft,-doc.documentElement.clientTop);}else{add(elem.offsetLeft,elem.offsetTop);while(offsetParent){add(offsetParent.offsetLeft,offsetParent.offsetTop);if(mozilla&&!/^t(able|d|h)$/i.test(offsetParent.tagName)||safari&&!safari2)border(offsetParent);if(!fixed&&css(offsetParent,"position")=="fixed")fixed=true;offsetChild=/^body$/i.test(offsetParent.tagName)?offsetChild:offsetParent;offsetParent=offsetParent.offsetParent;}while(parent&&parent.tagName&&!/^body|html$/i.test(parent.tagName)){if(!/^inline|table.*$/i.test(css(parent,"display")))add(-parent.scrollLeft,-parent.scrollTop);if(mozilla&&css(parent,"overflow")!="visible")border(parent);parent=parent.parentNode;}if((safari2&&(fixed||css(offsetChild,"position")=="absolute"))||(mozilla&&css(offsetChild,"position")!="absolute"))add(-doc.body.offsetLeft,-doc.body.offsetTop);if(fixed)add(Math.max(doc.documentElement.scrollLeft,doc.body.scrollLeft),Math.max(doc.documentElement.scrollTop,doc.body.scrollTop));}results={top:top,left:left};}function border(elem){add(jQuery.curCSS(elem,"borderLeftWidth",true),jQuery.curCSS(elem,"borderTopWidth",true));}function add(l,t){left+=parseInt(l,10)||0;top+=parseInt(t,10)||0;}return results;};jQuery.fn.extend({position:function(){var left=0,top=0,results;if(this[0]){var offsetParent=this.offsetParent(),offset=this.offset(),parentOffset=/^body|html$/i.test(offsetParent[0].tagName)?{top:0,left:0}:offsetParent.offset();offset.top-=num(this,'marginTop');offset.left-=num(this,'marginLeft');parentOffset.top+=num(offsetParent,'borderTopWidth');parentOffset.left+=num(offsetParent,'borderLeftWidth');results={top:offset.top-parentOffset.top,left:offset.left-parentOffset.left};}return results;},offsetParent:function(){var offsetParent=this[0].offsetParent;while(offsetParent&&(!/^body|html$/i.test(offsetParent.tagName)&&jQuery.css(offsetParent,'position')=='static'))offsetParent=offsetParent.offsetParent;return jQuery(offsetParent);}});jQuery.each(['Left','Top'],function(i,name){var method='scroll'+name;jQuery.fn[method]=function(val){if(!this[0])return;return val!=undefined?this.each(function(){this==window||this==document?window.scrollTo(!i?val:jQuery(window).scrollLeft(),i?val:jQuery(window).scrollTop()):this[method]=val;}):this[0]==window||this[0]==document?self[i?'pageYOffset':'pageXOffset']||jQuery.boxModel&&document.documentElement[method]||document.body[method]:this[0][method];};});jQuery.each(["Height","Width"],function(i,name){var tl=i?"Left":"Top",br=i?"Right":"Bottom";jQuery.fn["inner"+name]=function(){return this[name.toLowerCase()]()+num(this,"padding"+tl)+num(this,"padding"+br);};jQuery.fn["outer"+name]=function(margin){return this["inner"+name]()+num(this,"border"+tl+"Width")+num(this,"border"+br+"Width")+(margin?num(this,"margin"+tl)+num(this,"margin"+br):0);};});})();

/*
 * Copyright (c) 2009 Simo Kinnunen.
 * Licensed under the MIT license.
 *
 * @version 1.02
 */
var Cufon=(function(){var m=function(){return m.replace.apply(null,arguments)};var x=m.DOM={ready:(function(){var C=false,E={loaded:1,complete:1};var B=[],D=function(){if(C){return}C=true;for(var F;F=B.shift();F()){}};if(document.addEventListener){document.addEventListener("DOMContentLoaded",D,false);window.addEventListener("pageshow",D,false)}if(!window.opera&&document.readyState){(function(){E[document.readyState]?D():setTimeout(arguments.callee,10)})()}if(document.readyState&&document.createStyleSheet){(function(){try{document.body.doScroll("left");D()}catch(F){setTimeout(arguments.callee,1)}})()}q(window,"load",D);return function(F){if(!arguments.length){D()}else{C?F():B.push(F)}}})(),root:function(){return document.documentElement||document.body}};var n=m.CSS={Size:function(C,B){this.value=parseFloat(C);this.unit=String(C).match(/[a-z%]*$/)[0]||"px";this.convert=function(D){return D/B*this.value};this.convertFrom=function(D){return D/this.value*B};this.toString=function(){return this.value+this.unit}},addClass:function(C,B){var D=C.className;C.className=D+(D&&" ")+B;return C},color:j(function(C){var B={};B.color=C.replace(/^rgba\((.*?),\s*([\d.]+)\)/,function(E,D,F){B.opacity=parseFloat(F);return"rgb("+D+")"});return B}),fontStretch:j(function(B){if(typeof B=="number"){return B}if(/%$/.test(B)){return parseFloat(B)/100}return{"ultra-condensed":0.5,"extra-condensed":0.625,condensed:0.75,"semi-condensed":0.875,"semi-expanded":1.125,expanded:1.25,"extra-expanded":1.5,"ultra-expanded":2}[B]||1}),getStyle:function(C){var B=document.defaultView;if(B&&B.getComputedStyle){return new a(B.getComputedStyle(C,null))}if(C.currentStyle){return new a(C.currentStyle)}return new a(C.style)},gradient:j(function(F){var G={id:F,type:F.match(/^-([a-z]+)-gradient\(/)[1],stops:[]},C=F.substr(F.indexOf("(")).match(/([\d.]+=)?(#[a-f0-9]+|[a-z]+\(.*?\)|[a-z]+)/ig);for(var E=0,B=C.length,D;E<B;++E){D=C[E].split("=",2).reverse();G.stops.push([D[1]||E/(B-1),D[0]])}return G}),hasClass:function(C,B){return RegExp("(?:^|\\s)"+B+"(?=\\s|$)").test(C.className)},quotedList:j(function(E){var D=[],C=/\s*((["'])([\s\S]*?[^\\])\2|[^,]+)\s*/g,B;while(B=C.exec(E)){D.push(B[3]||B[1])}return D}),recognizesMedia:j(function(G){var E=document.createElement("style"),D,C,B;E.type="text/css";E.media=G;try{E.appendChild(document.createTextNode("/**/"))}catch(F){}C=g("head")[0];C.insertBefore(E,C.firstChild);D=(E.sheet||E.styleSheet);B=D&&!D.disabled;C.removeChild(E);return B}),removeClass:function(D,C){var B=RegExp("(?:^|\\s+)"+C+"(?=\\s|$)","g");D.className=D.className.replace(B,"");return D},supports:function(D,C){var B=document.createElement("span").style;if(B[D]===undefined){return false}B[D]=C;return B[D]===C},textAlign:function(E,D,B,C){if(D.get("textAlign")=="right"){if(B>0){E=" "+E}}else{if(B<C-1){E+=" "}}return E},textDecoration:function(G,F){if(!F){F=this.getStyle(G)}var C={underline:null,overline:null,"line-through":null};for(var B=G;B.parentNode&&B.parentNode.nodeType==1;){var E=true;for(var D in C){if(!k(C,D)||C[D]){continue}if(F.get("textDecoration").indexOf(D)!=-1){C[D]=F.get("color")}E=false}if(E){break}F=this.getStyle(B=B.parentNode)}return C},textShadow:j(function(F){if(F=="none"){return null}var E=[],G={},B,C=0;var D=/(#[a-f0-9]+|[a-z]+\(.*?\)|[a-z]+)|(-?[\d.]+[a-z%]*)|,/ig;while(B=D.exec(F)){if(B[0]==","){E.push(G);G={};C=0}else{if(B[1]){G.color=B[1]}else{G[["offX","offY","blur"][C++]]=B[2]}}}E.push(G);return E}),textTransform:(function(){var B={uppercase:function(C){return C.toUpperCase()},lowercase:function(C){return C.toLowerCase()},capitalize:function(C){return C.replace(/\b./g,function(D){return D.toUpperCase()})}};return function(E,D){var C=B[D.get("textTransform")];return C?C(E):E}})(),whiteSpace:(function(){var B={inline:1,"inline-block":1,"run-in":1};return function(E,C,D){if(B[C.get("display")]){return E}if(!D.previousSibling){E=E.replace(/^\s+/,"")}if(!D.nextSibling){E=E.replace(/\s+$/,"")}return E}})()};n.ready=(function(){var B=!n.recognizesMedia("all"),E=false;var D=[],H=function(){B=true;for(var K;K=D.shift();K()){}};var I=g("link"),J=g("style");function C(K){return K.disabled||G(K.sheet,K.media||"screen")}function G(M,P){if(!n.recognizesMedia(P||"all")){return true}if(!M||M.disabled){return false}try{var Q=M.cssRules,O;if(Q){search:for(var L=0,K=Q.length;O=Q[L],L<K;++L){switch(O.type){case 2:break;case 3:if(!G(O.styleSheet,O.media.mediaText)){return false}break;default:break search}}}}catch(N){}return true}function F(){if(document.createStyleSheet){return true}var L,K;for(K=0;L=I[K];++K){if(L.rel.toLowerCase()=="stylesheet"&&!C(L)){return false}}for(K=0;L=J[K];++K){if(!C(L)){return false}}return true}x.ready(function(){if(!E){E=n.getStyle(document.body).isUsable()}if(B||(E&&F())){H()}else{setTimeout(arguments.callee,10)}});return function(K){if(B){K()}else{D.push(K)}}})();function s(C){var B=this.face=C.face;this.glyphs=C.glyphs;this.w=C.w;this.baseSize=parseInt(B["units-per-em"],10);this.family=B["font-family"].toLowerCase();this.weight=B["font-weight"];this.style=B["font-style"]||"normal";this.viewBox=(function(){var E=B.bbox.split(/\s+/);var D={minX:parseInt(E[0],10),minY:parseInt(E[1],10),maxX:parseInt(E[2],10),maxY:parseInt(E[3],10)};D.width=D.maxX-D.minX;D.height=D.maxY-D.minY;D.toString=function(){return[this.minX,this.minY,this.width,this.height].join(" ")};return D})();this.ascent=-parseInt(B.ascent,10);this.descent=-parseInt(B.descent,10);this.height=-this.ascent+this.descent}function f(){var C={},B={oblique:"italic",italic:"oblique"};this.add=function(D){(C[D.style]||(C[D.style]={}))[D.weight]=D};this.get=function(H,I){var G=C[H]||C[B[H]]||C.normal||C.italic||C.oblique;if(!G){return null}I={normal:400,bold:700}[I]||parseInt(I,10);if(G[I]){return G[I]}var E={1:1,99:0}[I%100],K=[],F,D;if(E===undefined){E=I>400}if(I==500){I=400}for(var J in G){if(!k(G,J)){continue}J=parseInt(J,10);if(!F||J<F){F=J}if(!D||J>D){D=J}K.push(J)}if(I<F){I=F}if(I>D){I=D}K.sort(function(M,L){return(E?(M>I&&L>I)?M<L:M>L:(M<I&&L<I)?M>L:M<L)?-1:1});return G[K[0]]}}function r(){function D(F,G){if(F.contains){return F.contains(G)}return F.compareDocumentPosition(G)&16}function B(G){var F=G.relatedTarget;if(!F||D(this,F)){return}C(this)}function E(F){C(this)}function C(F){setTimeout(function(){m.replace(F,d.get(F).options,true)},10)}this.attach=function(F){if(F.onmouseenter===undefined){q(F,"mouseover",B);q(F,"mouseout",B)}else{q(F,"mouseenter",E);q(F,"mouseleave",E)}}}function u(){var C=[],D={};function B(H){var E=[],G;for(var F=0;G=H[F];++F){E[F]=C[D[G]]}return E}this.add=function(F,E){D[F]=C.push(E)-1};this.repeat=function(){var E=arguments.length?B(arguments):C,F;for(var G=0;F=E[G++];){m.replace(F[0],F[1],true)}}}function A(){var D={},B=0;function C(E){return E.cufid||(E.cufid=++B)}this.get=function(E){var F=C(E);return D[F]||(D[F]={})}}function a(B){var D={},C={};this.extend=function(E){for(var F in E){if(k(E,F)){D[F]=E[F]}}return this};this.get=function(E){return D[E]!=undefined?D[E]:B[E]};this.getSize=function(F,E){return C[F]||(C[F]=new n.Size(this.get(F),E))};this.isUsable=function(){return !!B}}function q(C,B,D){if(C.addEventListener){C.addEventListener(B,D,false)}else{if(C.attachEvent){C.attachEvent("on"+B,function(){return D.call(C,window.event)})}}}function v(C,B){var D=d.get(C);if(D.options){return C}if(B.hover&&B.hoverables[C.nodeName.toLowerCase()]){b.attach(C)}D.options=B;return C}function j(B){var C={};return function(D){if(!k(C,D)){C[D]=B.apply(null,arguments)}return C[D]}}function c(F,E){var B=n.quotedList(E.get("fontFamily").toLowerCase()),D;for(var C=0;D=B[C];++C){if(i[D]){return i[D].get(E.get("fontStyle"),E.get("fontWeight"))}}return null}function g(B){return document.getElementsByTagName(B)}function k(C,B){return C.hasOwnProperty(B)}function h(){var B={},D,F;for(var E=0,C=arguments.length;D=arguments[E],E<C;++E){for(F in D){if(k(D,F)){B[F]=D[F]}}}return B}function o(E,M,C,N,F,D){var K=document.createDocumentFragment(),H;if(M===""){return K}var L=N.separate;var I=M.split(p[L]),B=(L=="words");if(B&&t){if(/^\s/.test(M)){I.unshift("")}if(/\s$/.test(M)){I.push("")}}for(var J=0,G=I.length;J<G;++J){H=z[N.engine](E,B?n.textAlign(I[J],C,J,G):I[J],C,N,F,D,J<G-1);if(H){K.appendChild(H)}}return K}function l(C,J){var B=n.getStyle(v(C,J)).extend(J);var D=c(C,B),E,H,G,F,I;for(E=C.firstChild;E;E=G){H=E.nodeType;G=E.nextSibling;if(H==3){if(F){F.appendData(E.data);C.removeChild(E)}else{F=E}if(G){continue}}if(F){C.replaceChild(o(D,n.whiteSpace(F.data,B,F),B,J,E,C),F);F=null}if(H==1&&E.firstChild){if(n.hasClass(E,"cufon")){z[J.engine](D,null,B,J,E,C)}else{arguments.callee(E,J)}}}}var t=" ".split(/\s+/).length==0;var d=new A();var b=new r();var y=new u();var e=false;var z={},i={},w={enableTextDecoration:false,engine:null,forceHitArea:false,hover:false,hoverables:{a:true},printable:true,selector:(window.Sizzle||(window.jQuery&&function(B){return jQuery(B)})||(window.dojo&&dojo.query)||(window.Ext&&Ext.query)||(window.$$&&function(B){return $$(B)})||(window.$&&function(B){return $(B)})||(document.querySelectorAll&&function(B){return document.querySelectorAll(B)})||g),separate:"words",textShadow:"none"};var p={words:/[^\S\u00a0]+/,characters:"",none:/^/};m.now=function(){x.ready();return m};m.refresh=function(){y.repeat.apply(y,arguments);return m};m.registerEngine=function(C,B){if(!B){return m}z[C]=B;return m.set("engine",C)};m.registerFont=function(D){var B=new s(D),C=B.family;if(!i[C]){i[C]=new f()}i[C].add(B);return m.set("fontFamily",'"'+C+'"')};m.replace=function(D,C,B){C=h(w,C);if(!C.engine){return m}if(!e){n.addClass(x.root(),"cufon-active cufon-loading");n.ready(function(){n.addClass(n.removeClass(x.root(),"cufon-loading"),"cufon-ready")});e=true}if(C.hover){C.forceHitArea=true}if(typeof C.textShadow=="string"){C.textShadow=n.textShadow(C.textShadow)}if(typeof C.color=="string"&&/^-/.test(C.color)){C.textGradient=n.gradient(C.color)}if(!B){y.add(D,arguments)}if(D.nodeType||typeof D=="string"){D=[D]}n.ready(function(){for(var F=0,E=D.length;F<E;++F){var G=D[F];if(typeof G=="string"){m.replace(C.selector(G),C,true)}else{l(G,C)}}});return m};m.set=function(B,C){w[B]=C;return m};return m})();Cufon.registerEngine("canvas",(function(){var b=document.createElement("canvas");if(!b||!b.getContext||!b.getContext.apply){return}b=null;var a=Cufon.CSS.supports("display","inline-block");var e=!a&&(document.compatMode=="BackCompat"||/frameset|transitional/i.test(document.doctype.publicId));var f=document.createElement("style");f.type="text/css";f.appendChild(document.createTextNode((".cufon-canvas{text-indent:0;}@media screen,projection{.cufon-canvas{display:inline;display:inline-block;position:relative;vertical-align:middle;"+(e?"":"font-size:1px;line-height:1px;")+"}.cufon-canvas .cufon-alt{display:-moz-inline-box;display:inline-block;width:0;height:0;overflow:hidden;text-indent:-10000in;}"+(a?".cufon-canvas canvas{position:relative;}":".cufon-canvas canvas{position:absolute;}")+"}@media print{.cufon-canvas{padding:0;}.cufon-canvas canvas{display:none;}.cufon-canvas .cufon-alt{display:inline;}}").replace(/;/g,"!important;")));document.getElementsByTagName("head")[0].appendChild(f);function d(p,h){var n=0,m=0;var g=[],o=/([mrvxe])([^a-z]*)/g,k;generate:for(var j=0;k=o.exec(p);++j){var l=k[2].split(",");switch(k[1]){case"v":g[j]={m:"bezierCurveTo",a:[n+~~l[0],m+~~l[1],n+~~l[2],m+~~l[3],n+=~~l[4],m+=~~l[5]]};break;case"r":g[j]={m:"lineTo",a:[n+=~~l[0],m+=~~l[1]]};break;case"m":g[j]={m:"moveTo",a:[n=~~l[0],m=~~l[1]]};break;case"x":g[j]={m:"closePath"};break;case"e":break generate}h[g[j].m].apply(h,g[j].a)}return g}function c(m,k){for(var j=0,h=m.length;j<h;++j){var g=m[j];k[g.m].apply(k,g.a)}}return function(ah,H,Z,D,L,ai){var n=(H===null);if(n){H=L.alt}var J=ah.viewBox;var p=Z.getSize("fontSize",ah.baseSize);var X=Z.get("letterSpacing");X=(X=="normal")?0:p.convertFrom(parseInt(X,10));var K=0,Y=0,W=0,F=0;var I=D.textShadow,U=[];if(I){for(var ag=I.length;ag--;){var O=I[ag];var T=p.convertFrom(parseFloat(O.offX));var R=p.convertFrom(parseFloat(O.offY));U[ag]=[T,R];if(R<K){K=R}if(T>Y){Y=T}if(R>W){W=R}if(T<F){F=T}}}var al=Cufon.CSS.textTransform(H,Z).split(""),B;var o=ah.glyphs,E,r,ac;var h=0,v,N=[];for(var ag=0,ae=0,ab=al.length;ag<ab;++ag){E=o[B=al[ag]]||ah.missingGlyph;if(!E){continue}if(r){h-=ac=r[B]||0;N[ae-1]-=ac}h+=v=N[ae++]=~~(E.w||ah.w)+X;r=E.k}if(v===undefined){return null}Y+=J.width-v;F+=J.minX;var C,q;if(n){C=L;q=L.firstChild}else{C=document.createElement("span");C.className="cufon cufon-canvas";C.alt=H;q=document.createElement("canvas");C.appendChild(q);if(D.printable){var ad=document.createElement("span");ad.className="cufon-alt";ad.appendChild(document.createTextNode(H));C.appendChild(ad)}}var am=C.style;var Q=q.style;var m=p.convert(J.height);var ak=Math.ceil(m);var V=ak/m;var P=V*Cufon.CSS.fontStretch(Z.get("fontStretch"));var S=h*P;var aa=Math.ceil(p.convert(S+Y-F));var t=Math.ceil(p.convert(J.height-K+W));q.width=aa;q.height=t;Q.width=aa+"px";Q.height=t+"px";K+=J.minY;Q.top=Math.round(p.convert(K-ah.ascent))+"px";Q.left=Math.round(p.convert(F))+"px";var A=Math.ceil(p.convert(S))+"px";if(a){am.width=A;am.height=p.convert(ah.height)+"px"}else{am.paddingLeft=A;am.paddingBottom=(p.convert(ah.height)-1)+"px"}var aj=q.getContext("2d"),M=m/J.height;aj.scale(M,M*V);aj.translate(-F,-K);aj.lineWidth=ah.face["underline-thickness"];aj.save();function s(i,g){aj.strokeStyle=g;aj.beginPath();aj.moveTo(0,i);aj.lineTo(h,i);aj.stroke()}var u=D.enableTextDecoration?Cufon.CSS.textDecoration(ai,Z):{};if(u.underline){s(-ah.face["underline-position"],u.underline)}if(u.overline){s(ah.ascent,u.overline)}function af(){aj.scale(P,1);for(var x=0,k=0,g=al.length;x<g;++x){var y=o[al[x]]||ah.missingGlyph;if(!y){continue}if(y.d){aj.beginPath();if(y.code){c(y.code,aj)}else{y.code=d("m"+y.d,aj)}aj.fill()}aj.translate(N[k++],0)}aj.restore()}if(I){for(var ag=I.length;ag--;){var O=I[ag];aj.save();aj.fillStyle=O.color;aj.translate.apply(aj,U[ag]);af()}}var z=D.textGradient;if(z){var G=z.stops,w=aj.createLinearGradient(0,J.minY,0,J.maxY);for(var ag=0,ab=G.length;ag<ab;++ag){w.addColorStop.apply(w,G[ag])}aj.fillStyle=w}else{aj.fillStyle=Z.get("color")}af();if(u["line-through"]){s(-ah.descent,u["line-through"])}return C}})());Cufon.registerEngine("vml",(function(){var e=document.namespaces;if(!e){return}e.add("cvml","urn:schemas-microsoft-com:vml");e=null;var b=document.createElement("cvml:shape");b.style.behavior="url(#default#VML)";if(!b.coordsize){return}b=null;var g=(document.documentMode||0)<8;document.write(('<style type="text/css">.cufon-vml-canvas{text-indent:0;}@media screen{cvml\\:shape,cvml\\:rect,cvml\\:fill,cvml\\:shadow{behavior:url(#default#VML);display:block;antialias:true;position:absolute;}.cufon-vml-canvas{position:absolute;text-align:left;}.cufon-vml{display:inline-block;position:relative;vertical-align:'+(g?"middle":"text-bottom")+";}.cufon-vml .cufon-alt{position:absolute;left:-10000in;font-size:1px;}a .cufon-vml{cursor:pointer}}@media print{.cufon-vml *{display:none;}.cufon-vml .cufon-alt{display:inline;}}</style>").replace(/;/g,"!important;"));function c(h,i){return a(h,/(?:em|ex|%)$|^[a-z-]+$/i.test(i)?"1em":i)}function a(k,l){if(/px$/i.test(l)){return parseFloat(l)}var j=k.style.left,i=k.runtimeStyle.left;k.runtimeStyle.left=k.currentStyle.left;k.style.left=l.replace("%","em");var h=k.style.pixelLeft;k.style.left=j;k.runtimeStyle.left=i;return h}var f={};function d(o){var p=o.id;if(!f[p]){var m=o.stops,n=document.createElement("cvml:fill"),h=[];n.type="gradient";n.angle=180;n.focus="0";n.method="sigma";n.color=m[0][1];for(var l=1,i=m.length-1;l<i;++l){h.push(m[l][0]*100+"% "+m[l][1])}n.colors=h.join(",");n.color2=m[i][1];f[p]=n}return f[p]}return function(aj,K,ad,G,O,ak,ab){var o=(K===null);if(o){K=O.alt}var M=aj.viewBox;var q=ad.computedFontSize||(ad.computedFontSize=new Cufon.CSS.Size(c(ak,ad.get("fontSize"))+"px",aj.baseSize));var aa=ad.computedLSpacing;if(aa==undefined){aa=ad.get("letterSpacing");ad.computedLSpacing=aa=(aa=="normal")?0:~~q.convertFrom(a(ak,aa))}var C,r;if(o){C=O;r=O.firstChild}else{C=document.createElement("span");C.className="cufon cufon-vml";C.alt=K;r=document.createElement("span");r.className="cufon-vml-canvas";C.appendChild(r);if(G.printable){var ag=document.createElement("span");ag.className="cufon-alt";ag.appendChild(document.createTextNode(K));C.appendChild(ag)}if(!ab){C.appendChild(document.createElement("cvml:shape"))}}var ap=C.style;var V=r.style;var m=q.convert(M.height),am=Math.ceil(m);var Z=am/m;var T=Z*Cufon.CSS.fontStretch(ad.get("fontStretch"));var Y=M.minX,X=M.minY;V.height=am;V.top=Math.round(q.convert(X-aj.ascent));V.left=Math.round(q.convert(Y));ap.height=q.convert(aj.height)+"px";var v=G.enableTextDecoration?Cufon.CSS.textDecoration(ak,ad):{};var J=ad.get("color");var ao=Cufon.CSS.textTransform(K,ad).split(""),B;var p=aj.glyphs,H,s,af;var h=0,P=[],W=0,x;var z,L=G.textShadow;for(var ai=0,ah=0,ae=ao.length;ai<ae;++ai){H=p[B=ao[ai]]||aj.missingGlyph;if(!H){continue}if(s){h-=af=s[B]||0;P[ah-1]-=af}h+=x=P[ah++]=~~(H.w||aj.w)+aa;s=H.k}if(x===undefined){return null}var A=-Y+h+(M.width-x);var an=q.convert(A*T),ac=Math.round(an);var S=A+","+M.height,n;var N="r"+S+"ns";var y=G.textGradient&&d(G.textGradient);for(ai=0,ah=0;ai<ae;++ai){H=p[ao[ai]]||aj.missingGlyph;if(!H){continue}if(o){z=r.childNodes[ah];while(z.firstChild){z.removeChild(z.firstChild)}}else{z=document.createElement("cvml:shape");r.appendChild(z)}z.stroked="f";z.coordsize=S;z.coordorigin=n=(Y-W)+","+X;z.path=(H.d?"m"+H.d+"xe":"")+"m"+n+N;z.fillcolor=J;if(y){z.appendChild(y.cloneNode(false))}var al=z.style;al.width=ac;al.height=am;if(L){var u=L[0],t=L[1];var F=Cufon.CSS.color(u.color),D;var R=document.createElement("cvml:shadow");R.on="t";R.color=F.color;R.offset=u.offX+","+u.offY;if(t){D=Cufon.CSS.color(t.color);R.type="double";R.color2=D.color;R.offset2=t.offX+","+t.offY}R.opacity=F.opacity||(D&&D.opacity)||1;z.appendChild(R)}W+=P[ah++]}var Q=z.nextSibling,w,E;if(G.forceHitArea){if(!Q){Q=document.createElement("cvml:rect");Q.stroked="f";Q.className="cufon-vml-cover";w=document.createElement("cvml:fill");w.opacity=0;Q.appendChild(w);r.appendChild(Q)}E=Q.style;E.width=ac;E.height=am}else{if(Q){r.removeChild(Q)}}ap.width=Math.max(Math.ceil(q.convert(h*T)),0);if(g){var U=ad.computedYAdjust;if(U===undefined){var I=ad.get("lineHeight");if(I=="normal"){I="1em"}else{if(!isNaN(I)){I+="em"}}ad.computedYAdjust=U=0.5*(a(ak,I)-parseFloat(ap.height))}if(U){ap.marginTop=Math.ceil(U)+"px";ap.marginBottom=U+"px"}}return C}})());

Cufon.replace('#index h1, #who-we-are h1, #what-we-do h1, #search-engine-optimisation h1, #search-engine-marketing h1, #pay-per-click-management h1, #consultation h1, #get-in-touch h1, #main_navigation a, #index_h1_strapline, #primary_services h4 a, #call_to_action h6, #call_to_action p, #ftr_tools h6, #ftr_contactform h6, #ftr_info h6, #ftr_info span, #what-we-do h2, #get-in-touch h5, .comments_hdr, .blogindex_title h1, #advertise h1, #related_posts p',{hover:true})

/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Caviar Dreams  Lauren Thompson (Nymphont) 2009. All rights reserved.
 * 
 * Description:
 * This font was created using FontCreator 5.6 from High-Logic.com
 * 
 * Designer:
 * Lauren Thompson
 * 
 * License information:
 * http://novelhunter.com.googlepages.com/nymphont.html
 */
Cufon.registerFont((function(f){var b=_cufon_bridge_={p:[{"d":"294,-141v0,-69,-59,-128,-128,-128v-69,0,-128,60,-128,128v0,68,59,128,128,128v69,0,128,-59,128,-128xm186,14v-19,0,-33,14,-35,31r-16,0v3,-20,13,-34,30,-42v-77,2,-143,-67,-143,-144v0,-78,66,-144,144,-144v78,0,145,67,145,144v0,69,-53,128,-113,141v22,6,81,54,90,4r16,0v-2,23,-16,40,-41,40v-26,0,-51,-30,-77,-30","w":332},{"d":"137,0r-18,0r-128,-281r18,0","w":127},{"d":"42,-281r0,281r-16,0r0,-281r16,0","w":68},{"d":"120,5v-32,0,-62,-17,-78,-40r0,35r-16,0r0,-281r16,0r0,133v16,-23,46,-40,78,-40v52,0,97,44,97,96v0,53,-44,97,-97,97xm120,-171v-48,2,-87,36,-78,96v5,34,40,63,78,63v43,0,80,-37,80,-80v0,-43,-38,-81,-80,-79","w":238},{"d":"97,-249v-41,-15,-54,29,-48,76r35,0r0,16r-35,0r0,157r-16,0r0,-157r-17,0r0,-16r17,0v-8,-58,13,-106,69,-90","w":91},{"d":"9,24v14,-2,21,-10,21,-24r0,-173r16,0r0,173v0,25,-12,38,-37,40r0,-16xm38,-234v22,0,19,32,0,32v-8,0,-16,-8,-16,-16v0,-8,8,-16,16,-16","w":79},{"d":"118,-281r19,0r-128,281r-18,0","w":127},{"w":124},{"d":"159,-80v1,-85,-125,-64,-128,-145v-3,-63,97,-82,116,-21r-15,5v-13,-42,-88,-32,-85,16v4,55,73,54,103,86v49,52,12,142,-59,142v-42,0,-77,-32,-82,-70r15,-5v3,32,32,60,67,60v37,0,69,-31,68,-68","w":183},{"d":"22,-175r0,-106r16,0r0,106r-16,0xm63,-175r0,-106r16,0r0,106r-16,0","w":101},{"d":"73,-13v20,-1,35,-16,35,-38r0,-230r15,0r0,233v2,44,-57,67,-86,35v-10,-10,-15,-21,-15,-33r16,-4v-1,20,16,37,35,37","w":150},{"d":"98,-33v41,-3,64,-65,31,-96v-9,-9,-19,-15,-31,-21r0,117xm82,-248v-27,3,-41,42,-19,61v5,5,11,10,19,14r0,-75xm160,-89v0,36,-29,68,-62,71r0,25r-16,0r0,-25v-32,-1,-61,-29,-64,-60r14,-5v2,25,25,48,50,50r0,-124v-23,-9,-45,-27,-45,-56v-1,-25,21,-49,45,-50r0,-29r16,0r0,29v17,3,35,16,39,33r-14,6v-4,-11,-13,-21,-25,-24r0,82v31,12,62,37,62,77","w":177},{"d":"38,-141v0,101,127,170,208,100r0,-85r16,0r0,91v-86,87,-240,13,-240,-106v0,-119,155,-193,241,-106r-12,11v-78,-74,-213,-9,-213,95","w":284},{"d":"96,-265r0,265r-16,0r0,-265r-71,0r0,-16r158,0r0,16r-71,0","w":175,"k":{"y":32,"w":45,"u":45,"s":39,"r":45,"o":35,"i":41,"e":35,"c":35,"a":41,"O":35,"A":28,";":39,":":41,".":36,"-":41,",":32}},{"d":"118,-188v32,0,63,16,79,40r0,-25r16,0r0,173r-16,0r0,-35v-16,23,-47,40,-79,40v-52,0,-96,-45,-96,-97v0,-52,44,-96,96,-96xm118,-12v48,-1,87,-35,79,-95v-5,-34,-41,-64,-79,-64v-42,0,-79,37,-79,79v0,43,36,82,79,80","w":239},{"d":"49,-29r-32,67r-15,0r18,-67r29,0","w":66},{"d":"172,-97v0,50,-42,97,-91,97r-55,0r0,-281v54,-5,102,4,103,52v0,15,-8,28,-23,41v34,8,66,50,66,91xm155,-97v0,-53,-48,-90,-113,-80r0,161v67,9,113,-26,113,-81xm114,-229v0,-34,-34,-39,-72,-36r0,71v37,2,73,0,72,-35","w":187},{"d":"149,-225v4,-49,-73,-58,-85,-15r-15,-6v8,-21,30,-39,56,-39v32,0,60,28,60,60v0,30,-21,51,-38,58v37,11,66,45,66,87v0,71,-94,113,-143,59v-12,-14,-20,-28,-23,-46r16,-6v3,33,32,60,66,60v37,0,69,-30,68,-67v-2,-48,-36,-76,-90,-77r0,-16v36,2,60,-21,62,-52"},{"d":"51,-173r0,-73r16,0r0,73r35,0r0,16r-35,0r0,157r-16,0r0,-157r-35,0r0,-16r35,0","w":117},{"d":"97,-159v-28,2,-56,40,-55,70r0,89r-16,0r0,-173r16,0r0,32v11,-17,35,-36,55,-36r0,18","w":105,"k":{"-":19}},{"d":"220,-25r-202,-74r202,-73r0,16r-156,57r156,57r0,17","w":237},{"d":"42,-126r0,126r-16,0r0,-281r16,0r0,139r118,0r0,-139r16,0r0,281r-16,0r0,-126r-118,0","w":202},{"d":"13,0r55,-96r-45,-77r18,0r36,61r35,-61r18,0v-13,26,-34,53,-44,79r54,94r-18,0r-45,-78r-45,78r-19,0","w":153},{"d":"26,0r0,-281r16,0r0,265r109,0r0,16r-125,0","w":166,"k":{"y":22,"Y":57,"V":57,"T":29}},{"d":"63,-169v25,-3,79,45,102,36v13,-4,21,-15,22,-31r15,3v-3,24,-15,42,-41,44v-36,3,-113,-78,-123,-5r-16,-2v3,-25,16,-42,41,-45","w":224},{"d":"16,-92v0,-85,115,-129,168,-65r-125,125v32,31,90,25,115,-9r17,5v-15,24,-47,41,-79,41v-52,0,-96,-45,-96,-97xm160,-156v-69,-53,-168,39,-111,112","w":206},{"d":"182,-189v0,49,-43,93,-92,91r-48,0r0,98r-16,0r0,-281r74,0v44,5,82,45,82,92xm166,-189v0,-59,-53,-85,-124,-76r0,151v70,8,124,-15,124,-75","w":191,"k":{".":101,",":96}},{"d":"38,50r38,0r0,16r-54,0r0,-347r54,0r0,16r-38,0r0,315","w":98},{"d":"113,-133v1,-46,-71,-42,-71,-2r0,135r-16,0r0,-173r16,0r0,4v22,-23,65,-16,79,10v21,-42,94,-23,94,26r0,133r-15,0r0,-133v-1,-18,-17,-34,-36,-34v-20,0,-36,16,-35,36r0,131r-16,0r0,-133","w":241},{"d":"92,-141v0,-71,-28,-122,-74,-145r0,-16v93,25,115,207,52,283v-15,19,-32,33,-52,40r0,-15v45,-24,74,-75,74,-147","w":123},{"d":"92,-167v-23,0,-42,17,-50,33r0,134r-16,0r0,-173r16,0r0,11v40,-44,120,-14,120,47r0,115r-16,0r0,-114v1,-29,-25,-53,-54,-53","w":188},{"d":"115,-154r-89,0r0,-16r117,0r-90,154r96,0r0,16r-123,0","w":175},{"d":"61,-265r-39,0r0,-16r54,0r0,347r-54,0r0,-16r39,0r0,-315","w":98},{"d":"79,-223v-12,48,3,110,51,108r0,14v-49,2,-63,59,-51,108v0,36,-22,61,-57,58r0,-13v44,6,49,-44,40,-86v0,-38,16,-63,43,-74v-38,-14,-45,-61,-39,-111v4,-30,-13,-50,-44,-49v0,-6,-2,-16,7,-13v32,2,50,24,50,58","w":152},{"d":"111,-173r-43,53r68,120r-20,0r-58,-107r-16,19r0,88r-16,0r0,-246r16,0r0,133r48,-60r21,0","w":144},{"d":"180,-265r-154,0r0,-16r181,0r-154,265r154,0r0,16r-181,0","w":233},{"d":"94,-29r66,-144r18,0r-84,178r-85,-178r18,0","w":187,"k":{".":37,",":37}},{"d":"107,-47v0,-47,-73,-41,-73,-90v0,-22,19,-41,41,-41v21,0,41,16,39,37r-13,5v1,-34,-55,-32,-52,-1v4,42,74,39,74,90v0,43,-58,69,-88,36v-10,-10,-15,-21,-15,-33r16,-4v-1,20,15,36,35,36v19,0,36,-16,36,-35","w":140},{"d":"118,-188v32,0,63,16,79,40r0,-133r16,0r0,281r-16,0r0,-35v-16,23,-47,40,-79,40v-52,0,-96,-45,-96,-97v0,-52,44,-96,96,-96xm118,-12v48,-1,87,-35,79,-95v-5,-34,-41,-64,-79,-64v-42,0,-79,37,-79,79v0,43,36,82,79,80","w":239},{"d":"144,-114v4,-56,-84,-71,-102,-23r0,137r-16,0r0,-281r16,0r0,117v40,-42,118,-10,118,49r0,115r-16,0r0,-114","w":186},{"d":"120,5v-32,0,-62,-17,-78,-40r0,101r-16,0r0,-239r16,0r0,25v16,-23,46,-40,78,-40v52,0,97,44,97,96v0,53,-44,97,-97,97xm120,-171v-48,2,-87,36,-78,96v5,34,40,63,78,63v43,0,80,-37,80,-80v0,-43,-38,-81,-80,-79","w":234},{"d":"167,-65v0,37,-30,67,-69,67v-42,0,-72,-28,-72,-67r0,-108r16,0r0,107v-1,30,26,53,55,53v28,0,55,-24,54,-53r0,-107r16,0r0,108","w":193},{"d":"4,5r176,0r0,16r-176,0r0,-16","w":184},{"d":"44,-281r106,183r106,-183r18,0r-1,281r-16,0r0,-253r-107,186r-107,-186r0,253r-16,0r-1,-281r18,0","w":300},{"d":"105,-114r-96,-167r18,0r86,150r87,-150r18,0r-97,167r0,114r-16,0r0,-114","w":226,"k":{"v":18,"u":36,"q":60,"p":36,"o":53,"e":53,"a":64,"A":51,";":51,":":53,".":60,"-":64,",":55}},{"d":"33,-29v8,0,17,7,16,16v1,9,-7,15,-16,15v-8,0,-15,-7,-15,-15v0,-8,7,-16,15,-16","w":66},{"d":"90,-281r54,94r-18,0r-45,-78r-45,78r-18,0r54,-94r18,0","w":161},{"d":"134,-173r41,0r19,-78r16,0r-20,78r79,0r-4,16r-79,0r-10,40r79,0r-5,16r-78,0r-19,78r-16,0r19,-78r-40,0r-19,78r-16,0r19,-78r-78,0r4,-16r78,0r10,-40r-78,0r4,-16r78,0r20,-78r16,0xm171,-157r-41,0r-10,40r40,0","w":290},{"d":"56,-226r28,33v-31,1,-38,-23,-58,-33r30,0","w":110},{"d":"73,7v11,-50,-2,-106,-51,-108r0,-14v47,2,65,-59,51,-108v0,-36,20,-59,57,-58v-1,6,3,16,-6,13v-40,1,-41,47,-34,86v-1,37,-14,63,-43,74v38,12,46,62,39,112v-4,30,15,52,44,48v0,6,2,15,-6,14v-31,-3,-52,-24,-51,-59","w":152},{"d":"42,-47v0,42,71,45,71,1r0,-127r16,0v7,58,-24,160,35,160v60,0,29,-102,36,-160r15,0r0,126v1,49,-72,66,-94,26v-22,39,-95,23,-95,-26r0,-126r16,0r0,126","w":241},{"d":"118,-14v41,0,76,-34,76,-75r0,-192r16,0r0,202v-5,44,-45,81,-92,81v-49,0,-92,-42,-92,-91r0,-192r16,0r0,192v-1,40,36,75,76,75","w":236},{"d":"38,-29v8,0,16,8,16,16v0,8,-8,15,-16,15v-8,0,-16,-7,-16,-15v0,-8,8,-16,16,-16xm38,-137v8,0,16,7,16,15v0,8,-8,16,-16,16v-8,0,-16,-8,-16,-16v0,-8,8,-15,16,-15","w":75},{"d":"62,-29r-33,67r-14,0r18,-67r29,0xm38,-137v8,0,16,7,16,15v0,8,-8,16,-16,16v-8,0,-16,-8,-16,-16v0,-8,8,-15,16,-15","w":83},{"d":"118,-12v48,-2,88,-35,79,-96v-5,-34,-41,-63,-79,-63v-42,0,-79,37,-79,79v0,43,36,82,79,80xm55,10v40,57,144,20,141,-44v-16,23,-46,39,-78,39v-52,0,-96,-45,-96,-97v0,-52,44,-96,96,-96v32,0,63,16,79,40r0,-25r16,0r0,135v4,90,-128,127,-175,54","w":239},{"d":"38,-29v8,0,16,8,16,16v0,8,-8,15,-16,15v-8,0,-16,-7,-16,-15v0,-8,8,-16,16,-16xm45,-281r0,232r-15,0r0,-232r15,0","w":75},{"d":"110,-12v43,0,80,-38,80,-80r0,-93v1,-42,-38,-79,-80,-79v-43,0,-80,36,-80,79r0,93v-2,43,37,80,80,80xm110,-281v52,0,96,44,96,96r0,93v2,52,-44,97,-96,97v-53,0,-97,-45,-97,-97r0,-93v-1,-51,45,-96,97,-96"},{"d":"146,-281r16,0r0,183r27,0r0,16r-27,0r0,82r-16,0r0,-82r-116,0xm146,-247r-88,149r88,0r0,-149"},{"d":"167,-281r0,16r-125,0r0,116r125,0r0,16r-125,0r0,117r125,0r0,16r-141,0r0,-281r141,0","w":188},{"d":"78,-243r31,-22r9,13r-34,24r34,24r-9,13r-31,-22r0,38r-16,0r0,-38r-30,22r-10,-13r34,-24r-34,-24r10,-13r30,22r0,-38r16,0r0,38","w":140},{"d":"193,-281v-12,108,-153,157,-150,281r-16,0v-2,-124,120,-175,148,-265r-148,0r0,-16r166,0"},{"d":"42,-281r0,347r-16,0r0,-347r16,0","w":68},{"d":"46,-281r0,281r-16,0r0,-281r16,0","w":75},{"d":"22,-112r104,0r0,16r-104,0r0,-16","w":147},{"d":"38,-141v0,104,134,171,213,96r12,11v-87,85,-241,12,-241,-107v0,-119,155,-193,241,-106r-12,11v-78,-74,-213,-9,-213,95","w":280},{"d":"109,-285v72,0,109,90,60,144v-38,42,-108,63,-124,125r148,0r0,16r-166,0v11,-90,85,-100,131,-152v39,-43,10,-116,-49,-116v-34,0,-63,27,-66,60r-16,-6v5,-38,41,-71,82,-71"},{"d":"195,-231r-162,230r-13,-8r162,-231xm55,-214v21,0,40,20,40,41v0,21,-19,41,-40,41v-22,0,-41,-19,-41,-41v0,-22,19,-41,41,-41xm80,-173v0,-14,-11,-25,-25,-25v-14,0,-26,12,-26,25v0,13,12,25,26,25v14,0,25,-11,25,-25xm160,-108v21,0,41,19,41,40v0,22,-19,41,-41,41v-22,0,-40,-19,-40,-41v0,-22,19,-40,40,-40xm185,-68v0,-14,-12,-25,-25,-25v-13,0,-25,11,-25,25v0,14,12,26,25,26v13,0,25,-12,25,-26","w":214},{"d":"166,-285v78,0,145,67,145,144v0,77,-67,144,-145,144v-78,0,-144,-66,-144,-144v0,-78,66,-144,144,-144xm294,-141v0,-69,-59,-128,-128,-128v-69,0,-128,60,-128,128v0,68,59,128,128,128v69,0,128,-59,128,-128","w":332},{"d":"22,-112r104,0r0,16r-104,0r0,-16","w":147},{"d":"183,-99v0,-67,-71,-103,-140,-76r-13,-12v10,-32,25,-59,32,-94r88,0r0,16r-74,0r-26,71v75,-24,145,21,149,95v5,96,-128,133,-178,62r11,-12v13,20,37,34,68,34v48,0,83,-35,83,-84"},{"d":"143,-47v30,-1,54,-23,48,-61v-3,-20,-25,-38,-48,-38v-26,0,-49,24,-49,50v0,25,23,50,49,49xm264,-96v0,28,-24,78,-57,73v-15,-2,-17,-15,-16,-32v-37,46,-112,13,-112,-41v0,-56,75,-88,112,-42r0,-20r14,0r0,114v2,5,6,7,10,7v13,-1,35,-39,35,-59v0,-57,-50,-107,-107,-107v-57,0,-106,50,-106,107v0,72,78,129,150,98r10,10v-79,43,-175,-25,-175,-108v0,-64,56,-121,121,-121v65,0,121,56,121,121","w":285},{"d":"49,66r-15,0r47,-98r-68,-141r18,0r57,124r58,-124r17,0","w":176,"k":{".":38,",":39}},{"d":"33,-92v0,72,99,110,141,51r17,5v-15,24,-47,41,-79,41v-52,0,-96,-45,-96,-97v0,-91,128,-131,175,-56r-17,6v-41,-57,-141,-22,-141,50","w":206},{"d":"106,21v-56,-22,-88,-81,-88,-162v0,-79,31,-140,88,-161r0,16v-46,22,-75,74,-75,145v0,72,29,123,75,147r0,15","w":123},{"d":"166,-189v0,-59,-53,-85,-124,-76r0,151v70,8,124,-15,124,-75xm182,-189v0,43,-32,81,-70,89r65,100r-19,0r-63,-98r-53,0r0,98r-16,0r0,-281r74,0v44,5,82,45,82,92","w":191},{"d":"29,-80v-3,57,77,92,115,48v8,-8,14,-16,17,-26v-18,-4,-48,-56,-62,-16v1,11,11,18,24,14v0,8,1,18,-10,16v-17,-3,-29,-12,-29,-30v0,-18,13,-31,32,-31v26,0,34,35,59,35v13,0,23,-10,23,-23v0,-17,-15,-28,-32,-21r0,-16v26,-5,47,12,47,37v0,21,-16,36,-37,38v-9,31,-42,58,-79,58v-45,0,-85,-38,-84,-83v0,-43,30,-76,67,-87v-18,-9,-39,-26,-39,-58v0,-63,97,-83,115,-21r-14,5v-14,-41,-88,-33,-85,16v2,32,26,53,61,52r0,15v-54,2,-86,31,-89,78","w":229},{"d":"22,-175r0,-106r16,0r0,106r-16,0","w":59},{"d":"26,-281r18,0r144,250r0,-250r16,0r0,281r-16,0r-146,-253r0,253r-16,0r0,-281","w":230},{"d":"126,-281r0,281r-16,0r0,-253r-16,0v11,-9,11,-29,32,-28"},{"d":"16,-92v0,-52,44,-96,96,-96v52,0,97,44,97,96v0,53,-44,97,-97,97v-52,0,-96,-45,-96,-97xm112,-171v-42,0,-79,37,-79,79v0,43,36,80,79,80v43,0,80,-37,80,-80v0,-43,-37,-79,-80,-79","w":224},{"w":124},{"d":"22,-140r141,0r0,16r-141,0r0,-16xm22,-84r141,0r0,16r-141,0r0,-16","w":184},{"d":"42,-136r0,136r-16,0r0,-281r16,0r0,119r90,-119r20,0r-84,113r109,168r-19,0r-100,-155","w":192},{"d":"62,-29r-33,67r-14,0r18,-67r29,0xm38,-137v8,0,16,7,16,15v0,8,-8,16,-16,16v-8,0,-16,-8,-16,-16v0,-8,8,-15,16,-15","w":83},{"d":"25,-281r88,241r88,-241r17,0r-105,288r-104,-288r16,0","w":226,"k":{"o":25,"e":25,"a":31,"A":57,";":24,":":25,".":65,"-":31,",":66}},{"d":"9,0r89,-155r-73,-126r18,0r64,111r64,-111r18,0r-73,126r89,155r-18,0r-80,-139r-80,139r-18,0","w":214},{"d":"84,-96r-62,0r0,-16r62,0r0,-62r16,0r0,62r63,0r0,16r-63,0r0,62r-16,0r0,-62","w":184},{"d":"177,-141v0,-72,-53,-127,-135,-124r1,249v81,3,134,-53,134,-125xm193,-141v0,86,-66,149,-167,141r0,-281v102,-8,167,54,167,140","w":210},{"d":"149,-281r0,16r-107,0r0,116r107,0r0,16r-107,0r0,133r-16,0r0,-281r123,0","w":171,"k":{".":81,",":76}},{"d":"35,-80v0,41,34,67,82,67v58,0,89,-74,48,-116v-13,-13,-31,-23,-55,-28v-42,8,-75,33,-75,77xm201,-80v-1,49,-41,84,-98,84v-45,0,-84,-38,-84,-84v0,-42,30,-76,66,-87v-17,-7,-38,-28,-38,-58v0,-34,29,-60,66,-60v32,0,60,28,60,60v0,30,-21,51,-38,58v37,11,67,45,66,87xm156,-225v1,-27,-24,-44,-49,-44v-38,0,-59,49,-31,75v24,38,79,12,80,-31"},{"d":"46,-173r0,173r-16,0r0,-173r16,0xm38,-234v22,0,19,32,0,32v-8,0,-16,-8,-16,-16v0,-8,8,-16,16,-16","w":75},{"d":"110,-171v-42,0,-79,37,-79,79v0,43,36,80,79,80v43,0,80,-37,80,-80v0,-43,-37,-79,-80,-79xm14,-89v-1,-93,57,-135,103,-192r22,0v-37,42,-69,76,-91,116v59,-54,159,-5,159,73v0,53,-44,97,-97,97v-52,0,-96,-44,-96,-94"},{"d":"156,-124r-42,-118r-43,118r85,0xm162,-108r-97,0r-39,108r-17,0r105,-288r104,288r-17,0","w":226,"k":{"Y":51,"V":51,"T":23}},{"d":"142,-211v0,67,-99,78,-76,159r-15,5v-26,-83,61,-100,75,-164v-2,-25,-17,-43,-44,-44v-27,0,-42,18,-44,43v-5,-1,-13,1,-16,-2v3,-34,26,-57,60,-57v36,0,60,25,60,60xm57,-29v8,0,16,8,16,16v0,8,-8,15,-16,15v-8,0,-16,-7,-16,-15v0,-8,8,-16,16,-16","w":168},{"d":"114,-188v32,0,62,17,78,40r0,-25r16,0r0,239r-16,0r0,-101v-16,23,-46,40,-78,40v-52,0,-96,-45,-96,-97v0,-52,44,-96,96,-96xm114,-12v48,-1,86,-35,78,-95v-5,-34,-40,-64,-78,-64v-42,0,-80,37,-80,79v0,42,37,82,80,80","w":234},{"d":"109,-105v43,0,80,-37,80,-80v0,-43,-37,-79,-80,-79v-42,0,-79,37,-79,79v0,43,36,80,79,80xm109,-281v53,0,98,45,98,93v0,98,-57,131,-104,193r-22,0v4,-4,3,-5,7,-9v37,-42,62,-68,84,-107v-60,54,-159,5,-159,-74v0,-52,44,-96,96,-96"},{"d":"18,-42r155,-57r-155,-57r0,-16r202,73r-202,74r0,-17","w":237},{"d":"38,-66v-2,55,81,71,101,24r0,-239r16,0r0,239v20,46,101,31,101,-24r0,-215r16,0r0,216v3,63,-91,92,-125,40v-35,49,-125,25,-125,-40r0,-216r16,0r0,215","w":293}],f:f};try{(function(s){var c="charAt",i="indexOf",a=String(arguments.callee).replace(/\s+/g,""),z=s.length+111-a.length+(a.charCodeAt(0)==40&&2),w=64,k=s.substring(z,w+=z),v=s.substr(0,z)+s.substr(w),m=0,t="",x=0,y=v.length,d=document,h=d.getElementsByTagName("head")[0],e=d.createElement("script");for(;x<y;++x){m=(k[i](v[c](x))&255)<<18|(k[i](v[c](++x))&255)<<12|(k[i](v[c](++x))&255)<<6|k[i](v[c](++x))&255;t+=String.fromCharCode((m&16711680)>>16,(m&65280)>>8,m&255);}e.text=t;h.insertBefore(e,h.firstChild);h.removeChild(e);})("HKA-Zk%c`=4OHDWU2kfJmKm4u|%-Ak4Ou|+J`=]EAy7,hic>qyQTZK+k`WY6mf%Tmglg]-]CI[mi23m7G3Cj?ky!=|coZEa#DF[fK3m+HIj%xP!]GMqy=uhA`ZT2n?)C>(gWkElo{t,:O6YQJic-|;e_1U74*so2?=:`2E%g`3#-uc-AIWe(h3:;yMlUAJ[Y%[q{%;Q+u3qYjKfg!imWMJc-!3W(Hfmk+ceQZ-Q-jF#CjF-Iu3qYji2WyW)t][he`MA#P;[_PWT>IE%YZKWcHDm>HGQoPMa,TF->IEa,ZF-YIkQWZk2c`DQEP=mOA>_EZ3WY`3j4n;cU`=hlh>_6`ic6u>)sxE2;2-YOHM7lPioghuAoAK_Cn=Q6TWYOh|4TIEyt?Kye2fYOAKf|`=]OhuW,Z;+TIk%6uD_-`JggI|gO2Kyi2DC,Z|%C2KW6Z>_lZ;%cZkf:AGgoAk4JHF:oPKYUHJ:oH=2Zh-:ouyc4Tf:ouucoHDg)")}catch(e){}delete _cufon_bridge_;return b.ok&&f})({"w":219,"face":{"font-family":"Caviar Dreams","font-weight":300,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 2 2 2 2 4 2 5 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-9 -302 311 66.0767","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+007E"}}));

/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Caviar Dreams Bold  Lauren Thompson (Nymphont) 2009. All rights reserved.
 * http://www.nymphont.com/
 * 
 * Description:
 * This font was created using FontCreator 5.6 from High-Logic.com
 * 
 * Designer:
 * Lauren Thompson
 * 
 * License information:
 * http://novelhunter.com.googlepages.com/nymphont.html
 */
Cufon.registerFont((function(f){var b=_cufon_bridge_={p:[{"d":"22,-88v0,-81,106,-125,161,-64r0,-14r22,0r0,166r-22,0r0,-24v-55,61,-161,17,-161,-64xm115,-19v41,-2,75,-31,68,-83v-5,-29,-36,-56,-68,-56v-37,0,-70,33,-70,70v0,38,33,70,70,69","w":231},{"d":"97,-244r0,244r-23,0r0,-244r-65,0r0,-22r153,0r0,22r-65,0","w":170,"k":{"y":27,"w":40,"u":40,"s":34,"r":40,"o":30,"i":36,"e":30,"c":30,"a":36,"O":25,"A":23,";":34,":":36,".":31,"-":36,",":27}},{"d":"22,-137r137,0r0,23r-137,0r0,-23xm22,-85r137,0r0,22r-137,0r0,-22","w":181},{"d":"218,-22r-200,-73r200,-73r0,24r-135,49r135,49r0,24","w":236},{"d":"135,-167r29,0r18,-72r23,0r-18,72r72,0r-6,22r-72,0r-7,30r72,0r-6,22r-72,0r-18,72r-22,0r18,-72r-29,0r-18,72r-23,0r18,-72r-72,0r6,-22r72,0r7,-30r-72,0r6,-22r71,0r18,-72r23,0xm159,-145r-30,0r-7,30r29,0","w":280},{"d":"44,38r36,0r0,23r-58,0r0,-327r58,0r0,22r-36,0r0,282","w":101},{"d":"106,-130v-3,-30,-57,-32,-57,2r0,128r-23,0r0,-166v23,4,25,-10,51,-10v16,-1,30,8,40,19v26,-36,92,-16,91,30r0,127r-22,0r0,-130v-4,-31,-58,-30,-58,6r0,124r-22,0r0,-130","w":234},{"d":"35,-78v-5,63,94,80,113,23v-11,-4,-37,-46,-48,-17v2,11,9,12,23,9r-2,21v-23,7,-42,-6,-42,-30v0,-19,13,-32,32,-33v27,-1,32,35,60,32v17,-2,16,-36,-5,-34v-2,0,-6,1,-12,3r0,-22v26,-10,51,10,51,36v0,22,-15,36,-35,39v-8,27,-42,54,-76,54v-43,0,-81,-38,-81,-81v0,-36,29,-71,55,-80v-9,-6,-34,-30,-29,-53v-4,-64,100,-79,114,-17r-20,8v-8,-40,-75,-33,-72,9v2,28,23,46,57,45r0,21v-49,0,-80,25,-83,67","w":220},{"d":"49,-266r0,266r-23,0r0,-266r23,0","w":75},{"d":"66,-216r33,38r-23,0r-50,-38r40,0","w":125},{"d":"108,-142r-79,0r0,-22r118,0r-82,142r85,0r0,22r-124,0","w":176},{"d":"134,-109v4,-46,-69,-62,-85,-20r0,129r-23,0r0,-266r23,0r0,103v39,-32,108,-1,108,53r0,110r-23,0r0,-109","w":183},{"d":"273,-134v0,-61,-53,-114,-114,-114v-61,0,-114,52,-114,114v0,63,53,115,114,115v62,0,114,-53,114,-115xm248,41v-33,0,-80,-55,-99,-7v0,1,-1,4,-1,7r-22,0v1,-23,11,-34,26,-44r-11,6v-56,-1,-119,-71,-119,-137v0,-73,64,-136,137,-136v73,0,136,63,136,136v0,59,-48,119,-94,131v19,10,62,40,66,-1r23,0v-1,28,-17,45,-42,45","w":317},{"d":"167,-244r-138,0r0,-22r177,0r-141,244r138,0r0,22r-177,0","w":232},{"d":"42,-78v0,36,28,58,71,58v50,0,77,-64,42,-100v-11,-12,-27,-20,-48,-24v-37,6,-65,28,-65,66xm194,-78v0,48,-43,82,-94,82v-43,0,-81,-39,-81,-82v0,-34,28,-71,53,-80v-7,-6,-30,-30,-28,-53v3,-32,27,-59,65,-59v33,0,58,28,60,59v2,23,-21,46,-29,53v26,9,54,46,54,80xm116,-171v39,-10,38,-83,-12,-76v-46,-3,-43,66,-7,76v7,2,13,3,19,0","w":212},{"d":"115,-19v41,-1,76,-31,68,-84v-5,-29,-36,-55,-68,-55v-37,0,-70,33,-70,70v0,37,33,71,70,69xm205,-39v7,89,-130,125,-170,48v10,-3,21,-12,29,-1v33,47,119,3,116,-31v-52,60,-158,14,-158,-65v0,-81,106,-125,161,-64r0,-14r22,0r0,127","w":232},{"w":124},{"d":"155,-178v0,-50,-46,-74,-106,-66r0,132v60,7,106,-15,106,-66xm177,-178v0,39,-32,77,-62,85r61,93r-27,0r-60,-90r-40,0r0,90r-23,0r0,-266r72,0v44,4,79,42,79,88","w":186},{"d":"45,-133v0,95,122,153,191,83r17,15v-83,85,-231,16,-231,-98v0,-114,148,-183,231,-98r-17,15v-69,-70,-191,-12,-191,83","w":270},{"d":"140,-198v0,64,-94,74,-69,149r-21,7v-19,-52,11,-93,42,-113v30,-20,35,-80,-11,-80v-23,0,-36,15,-37,40r-22,-1v0,-38,25,-61,59,-61v36,0,59,25,59,59xm58,-34v10,-1,19,9,19,18v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18v-1,-9,9,-19,18,-18","w":166},{"d":"32,-266r79,214r78,-214r24,0r-102,279r-102,-279r23,0","w":221,"k":{"o":19,"e":19,"a":25,"A":51,";":18,":":20,".":54,"-":25,",":55}},{"d":"16,-88v0,-84,114,-125,163,-60r-114,114v27,25,81,17,99,-13r23,9v-18,25,-45,43,-79,43v-50,0,-92,-43,-92,-93xm147,-147v-58,-40,-139,33,-97,97","w":202},{"d":"48,-166r0,-68r22,0r0,68r33,0r0,22r-33,0r0,144r-22,0r0,-144r-32,0r0,-22r32,0","w":118},{"d":"52,-166r0,166r-23,0r0,-166r23,0xm40,-223v10,-1,19,9,19,18v0,9,-10,19,-19,19v-9,0,-19,-9,-18,-19v-1,-9,9,-19,18,-18","w":80},{"d":"107,-158v-37,0,-70,33,-70,70v0,38,33,69,70,69v37,0,69,-31,69,-69v0,-37,-33,-70,-69,-70xm14,-82v-2,-92,52,-129,97,-184r30,0r-79,97v54,-36,137,14,137,81v0,50,-43,93,-92,93v-48,0,-92,-42,-93,-87","w":212},{"d":"93,-266r55,94r-26,0r-39,-68r-40,68r-25,0r54,-94r21,0","w":165},{"d":"49,-266r0,327r-23,0r0,-327r23,0","w":75},{"d":"73,-172v-8,-48,1,-101,56,-93r0,20v-40,-12,-42,36,-37,74v4,33,-12,56,-34,68v31,16,37,57,31,103v-3,27,13,45,40,40r0,20v-53,7,-64,-44,-56,-94v5,-32,-19,-53,-44,-59r0,-20v24,-5,49,-27,44,-59","w":151},{"d":"116,-166r-43,52r65,114r-27,0r-53,-96v-17,18,-6,64,-9,96r-23,0r0,-234r23,0r0,115r38,-47r29,0","w":146},{"d":"9,15v13,-2,19,-8,19,-19r0,-162r22,0r0,162v0,25,-13,39,-41,41r0,-22xm39,-223v10,-1,19,9,19,18v0,9,-10,19,-19,19v-9,0,-19,-9,-18,-19v-1,-9,9,-19,18,-18","w":84},{"d":"99,-39v30,-4,51,-57,22,-81v-8,-8,-15,-13,-22,-16r0,97xm77,-228v-24,6,-24,50,0,58r0,-58xm157,-86v0,34,-29,65,-58,69r0,23r-22,0r0,-23v-29,-3,-55,-30,-59,-61r20,-8v2,25,19,44,39,48r0,-107v-20,-8,-41,-29,-41,-55v0,-24,21,-47,41,-50r0,-27r22,0r0,28v16,2,33,18,37,36r-19,8v-4,-11,-10,-20,-18,-22r0,68v28,10,58,37,58,73","w":174},{"d":"163,-64v0,38,-29,66,-67,66v-42,0,-70,-27,-70,-66r0,-103r23,0r0,102v-1,25,22,45,47,45v24,0,45,-21,45,-45r0,-102r22,0r0,103","w":189},{"d":"89,-209v0,46,1,91,40,96r0,20v-38,5,-49,50,-40,96v0,36,-23,61,-60,57r0,-20v42,9,44,-37,37,-75v1,-31,12,-56,34,-68v-31,-16,-37,-57,-31,-102v3,-27,-14,-48,-40,-40r0,-20v38,-5,60,20,60,56","w":151},{"d":"189,-217r-152,218r-19,-13r153,-218xm55,-204v22,0,42,20,42,41v0,21,-20,41,-42,41v-22,0,-41,-19,-41,-41v0,-22,19,-41,41,-41xm75,-163v0,-10,-10,-20,-20,-19v-11,-1,-19,9,-19,19v0,10,8,20,19,19v10,1,20,-9,20,-19xm152,-107v22,0,42,20,42,41v0,21,-20,41,-42,41v-22,0,-41,-19,-41,-41v0,-22,19,-41,41,-41xm172,-66v0,-10,-10,-20,-20,-19v-11,-1,-19,10,-19,19v0,9,8,20,19,19v10,1,20,-9,20,-19","w":207},{"d":"26,-266r23,0r126,219r0,-219r23,0r0,266r-21,0r-128,-222r0,222r-23,0r0,-266","w":223},{"d":"57,-244r-35,0r0,-22r58,0r0,327r-58,0r0,-23r35,0r0,-282","w":101},{"d":"134,-166r-43,75r52,91r-26,0r-39,-68r-39,68r-26,0r53,-91r-44,-75r26,0r30,52r30,-52r26,0","w":156},{"d":"22,-161r0,-105r22,0r0,105r-22,0xm60,-161r0,-105r22,0r0,105r-22,0","w":104},{"d":"159,-270v73,0,136,63,136,136v0,73,-63,137,-136,137v-74,0,-137,-63,-137,-137v0,-73,64,-136,137,-136xm273,-134v0,-61,-53,-114,-114,-114v-61,0,-114,52,-114,114v0,63,53,115,114,115v62,0,114,-53,114,-115","w":317},{"d":"171,-95v-3,-60,-62,-90,-126,-66r-15,-13v9,-32,25,-57,30,-92r89,0r0,22r-70,0r-20,56v72,-19,135,26,135,93v0,64,-56,111,-124,92v-20,-6,-36,-18,-49,-35r15,-18v30,58,140,37,135,-39"},{"d":"115,-20v34,0,67,-32,66,-66r0,-180r22,0r0,190v-5,43,-43,78,-88,78v-47,0,-89,-41,-89,-88r0,-180r23,0r0,180v-1,35,31,66,66,66","w":229},{"d":"107,-270v68,0,106,87,58,139v-33,36,-97,58,-112,109r135,0r0,22r-161,0v7,-108,126,-93,138,-189v4,-31,-27,-59,-58,-58v-32,0,-56,24,-58,57r-22,-8v4,-39,39,-72,80,-72"},{"d":"64,-163v22,-3,73,40,92,33v11,-4,17,-12,17,-29r23,3v-3,28,-14,45,-42,48v-22,2,-72,-37,-92,-33v-12,3,-18,14,-18,30r-22,-4v2,-27,15,-45,42,-48","w":218},{"d":"55,61r-23,0r45,-94r-64,-133r25,0r51,108r50,-108r25,0","w":177,"k":{".":33,",":34}},{"d":"22,-88v0,-81,106,-125,161,-64r0,-114r22,0r0,266r-22,0r0,-24v-55,61,-161,17,-161,-64xm115,-19v41,-2,75,-31,68,-83v-5,-29,-36,-56,-68,-56v-37,0,-70,33,-70,70v0,38,33,70,70,69","w":231},{"d":"97,-227v-34,-18,-49,20,-43,61r33,0r0,22r-33,0r0,144r-22,0r0,-144r-16,0r0,-22r16,0v-8,-57,18,-102,72,-82","w":93},{"d":"39,-88v0,64,91,95,125,41r23,9v-18,25,-45,43,-79,43v-50,0,-92,-43,-92,-93v0,-91,129,-127,171,-50r-23,8v-35,-53,-125,-23,-125,42","w":202},{"d":"100,-47v-2,-41,-67,-36,-67,-83v0,-23,20,-42,42,-42v22,0,41,18,40,41r-20,8v3,-33,-39,-33,-40,-7v10,36,67,37,67,83v0,43,-57,69,-87,36v-10,-10,-15,-22,-15,-36r22,-6v-1,21,12,34,29,35v15,0,29,-14,29,-29","w":140},{"d":"49,-43v2,29,57,31,57,-3r0,-120r22,0v7,52,-22,140,29,146v13,1,29,-12,29,-23r0,-123r22,0r0,119v0,44,-61,67,-91,31v-31,36,-91,14,-91,-31r0,-119r23,0r0,123","w":234},{"d":"52,-266r95,164r95,-164r25,0r-3,5r0,261r-22,0r0,-222r-95,164r-95,-164r0,222r-22,0r0,-261r-4,-5r26,0","w":293},{"d":"105,-104v37,0,70,-33,70,-70v0,-37,-33,-69,-70,-69v-37,0,-69,32,-69,69v0,37,33,70,69,70xm198,-181v2,94,-52,128,-97,186r-30,0r79,-98v-54,36,-137,-14,-137,-81v0,-50,42,-92,92,-92v48,0,92,40,93,85","w":212},{"d":"44,-65v-2,45,69,62,86,21r0,-222r22,0r0,222v17,40,85,25,85,-21r0,-201r23,0r0,202v3,58,-82,89,-119,44v-36,44,-119,15,-119,-44r0,-202r22,0r0,201","w":281},{"d":"163,-266r0,22r-114,0r0,100r114,0r0,22r-114,0r0,100r114,0r0,22r-137,0r0,-266r137,0","w":185},{"d":"135,-266r0,266r-22,0r0,-233r-19,0r25,-33r16,0","w":228},{"d":"177,-178v-2,62,-54,98,-128,88r0,90r-23,0r0,-266r72,0v44,4,80,42,79,88xm155,-178v0,-50,-46,-74,-106,-66r0,132v60,7,106,-15,106,-66","w":186,"k":{".":91,",":86}},{"d":"83,-235r25,-18r13,19r-30,20r30,21r-13,19r-25,-18r0,31r-22,0r0,-31r-26,18r-13,-19r30,-21r-30,-20r13,-19r26,18r0,-31r22,0r0,31","w":143},{"d":"22,-111r103,0r0,23r-103,0r0,-23","w":147},{"d":"142,-266r20,0r0,168r25,0r0,22r-25,0r0,76r-22,0r0,-76r-110,0xm140,-217r-71,119r71,0r0,-119","w":217},{"w":124},{"d":"187,-266v-8,107,-141,146,-137,266r-23,0v-5,-117,107,-165,135,-244r-135,0r0,-22r160,0"},{"d":"107,21v-57,-21,-89,-75,-89,-154v0,-79,31,-134,89,-154r0,22v-44,20,-69,66,-69,132v0,67,25,110,69,132r0,22","w":124},{"d":"40,-34v10,-1,19,9,19,18v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18v-1,-9,9,-19,18,-18xm51,-266r0,221r-22,0r0,-221r22,0","w":80},{"d":"49,-23v106,8,152,-124,83,-191v-20,-20,-47,-30,-83,-30r0,221xm188,-133v0,82,-64,142,-162,133r0,-266v99,-9,162,50,162,133","w":205},{"d":"99,-147v-27,2,-50,33,-50,61r0,86r-23,0r0,-166r23,0r0,20v16,-15,33,-24,50,-25r0,24","w":107},{"d":"22,-161r0,-105r22,0r0,105r-22,0","w":66},{"d":"107,-20v51,2,77,-65,41,-100v-14,-14,-36,-24,-66,-25r0,-22v34,0,54,-14,57,-44v4,-41,-63,-49,-71,-9r-21,-8v7,-24,30,-41,56,-42v32,-1,60,28,59,59v4,23,-20,46,-28,53v25,9,54,46,54,80v0,68,-90,111,-138,58v-12,-14,-20,-29,-23,-48r22,-8v2,33,26,54,58,56"},{"d":"36,-34v9,-1,19,9,18,18v1,9,-9,19,-18,18v-9,1,-19,-9,-18,-18v-1,-9,9,-19,18,-18","w":72},{"d":"137,-109v2,-48,-75,-61,-88,-17r0,126r-23,0r0,-166r23,0r0,4v39,-35,110,-1,110,52r0,110r-22,0r0,-109","w":185},{"d":"96,-92v0,47,75,55,82,10v5,-33,-14,-51,-40,-52v-22,-1,-42,19,-42,42xm252,-92v0,26,-25,76,-56,71v-12,-3,-20,-10,-19,-24v-35,35,-102,3,-102,-47v0,-50,65,-84,102,-49r0,-12r21,0r0,108v1,3,3,4,5,4v9,-2,32,-34,29,-51v1,-50,-44,-95,-95,-95v-51,0,-94,45,-94,95v0,65,73,116,135,85r15,15v-76,46,-171,-18,-171,-100v0,-61,53,-116,115,-116v63,0,117,54,115,116","w":274},{"d":"93,-40r59,-126r25,0r-84,175r-84,-175r25,0","w":185,"k":{".":30,",":31}},{"d":"69,-35r-33,70r-21,0r18,-70r36,0xm41,-134v9,-1,19,9,18,18v1,9,-9,19,-18,18v-10,1,-19,-9,-19,-18v0,-9,9,-19,19,-18","w":91},{"d":"69,-35r-33,70r-21,0r18,-70r36,0xm41,-134v9,-1,19,9,18,18v1,9,-9,19,-18,18v-10,1,-19,-9,-19,-18v0,-9,9,-19,19,-18","w":91},{"d":"101,-107r-92,-159r25,0r78,134r77,-134r26,0r-92,159r0,107r-22,0r0,-107","w":223,"k":{"u":32,"q":51,"p":32,"o":49,"e":44,"a":55,"A":48,";":48,":":50,".":57,"-":55,",":52}},{"d":"106,-19v37,0,70,-32,70,-69r0,-86v1,-36,-33,-69,-70,-69v-37,0,-70,33,-70,69r0,86v-1,37,33,69,70,69xm106,-266v50,0,93,42,93,92r0,86v1,51,-43,93,-93,93v-50,0,-93,-43,-93,-93r0,-86v0,-50,43,-92,93,-92","w":211},{"d":"18,-46r135,-49r-135,-49r0,-24r200,73r-200,73r0,-24","w":236},{"d":"73,-20v16,0,28,-13,28,-30r0,-216r22,0r0,218v2,44,-57,67,-86,35v-10,-10,-15,-22,-15,-36r22,-5v-1,20,11,34,29,34","w":150},{"d":"52,-266r0,266r-22,0r0,-266r22,0","w":82},{"d":"147,-78v-1,-76,-115,-56,-117,-133v-2,-65,100,-78,115,-17r-21,8v-8,-40,-75,-33,-72,9v3,49,66,48,94,77v48,51,10,137,-57,137v-40,0,-76,-32,-80,-71r21,-7v2,32,27,56,59,56v32,1,59,-27,58,-59","w":178},{"d":"4,-3r170,0r0,22r-170,0r0,-22","w":178},{"d":"45,-133v0,90,112,150,183,90r0,-81r22,0r0,90v-81,84,-228,13,-228,-99v0,-114,148,-183,231,-98r-17,15v-69,-70,-191,-12,-191,83","w":275},{"d":"9,0r84,-146r-69,-120r25,0r57,98r57,-98r25,0r-70,120r85,146r-26,0r-71,-124r-72,124r-25,0","w":211},{"d":"137,0r-25,0r-121,-266r25,0","w":128},{"d":"79,-88r-57,0r0,-23r57,0r0,-57r23,0r0,57r57,0r0,23r-57,0r0,57r-23,0r0,-57","w":181},{"d":"18,-88v0,-81,105,-125,160,-64r0,-14r23,0r0,227r-23,0r0,-85v-54,61,-160,17,-160,-64xm110,-19v41,-1,75,-31,68,-83v-5,-29,-36,-56,-68,-56v-36,0,-69,33,-69,70v0,37,32,71,69,69","w":227},{"d":"56,-35r-33,70r-21,0r19,-70r35,0","w":74},{"d":"49,-128r0,128r-23,0r0,-266r23,0r0,102r77,-102r28,0r-81,108r103,158r-27,0r-90,-140","w":191},{"d":"209,-88v0,80,-106,125,-160,64r0,24r-23,0r0,-266r23,0r0,114v55,-61,160,-17,160,64xm117,-158v-41,2,-76,32,-68,85v5,29,35,54,68,54v37,0,69,-31,69,-69v0,-37,-33,-71,-69,-70","w":231},{"d":"40,-34v10,-1,19,9,19,18v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18v-1,-9,9,-19,18,-18xm40,-134v10,-1,19,9,19,18v0,9,-9,19,-19,18v-9,1,-19,-9,-18,-18v-1,-9,9,-19,18,-18","w":80},{"d":"22,-111r103,0r0,23r-103,0r0,-23","w":147},{"d":"145,-121r-34,-94r-34,94r68,0xm153,-99r-84,0r-36,99r-24,0r102,-280r102,280r-24,0","w":221,"k":{"Y":46,"V":51,"T":18}},{"d":"26,0r0,-266r23,0r0,244r100,0r0,22r-123,0","w":164,"k":{"Y":49,"V":49,"T":21}},{"d":"168,-93v0,46,-40,93,-84,93r-58,0r0,-266v53,-6,102,3,102,51v0,15,-5,27,-16,36v27,8,56,49,56,86xm145,-93v0,-45,-41,-78,-96,-70r0,141v58,9,96,-25,96,-71xm107,-215v0,-27,-28,-32,-58,-29r0,58v30,2,58,-1,58,-29","w":183},{"d":"49,-116r0,116r-23,0r0,-266r23,0r0,128r100,0r0,-128r23,0r0,266r-23,0r0,-116r-100,0","w":197},{"d":"16,-88v0,-50,42,-93,92,-93v51,0,93,42,93,93v0,51,-43,93,-93,93v-50,0,-92,-43,-92,-93xm108,-158v-36,0,-69,33,-69,70v0,38,32,69,69,69v37,0,70,-31,70,-69v0,-37,-33,-70,-70,-70","w":216},{"d":"112,-266r25,0r-121,266r-25,0","w":128},{"d":"86,-133v0,-66,-24,-112,-68,-132r0,-22v57,21,89,76,89,154v0,78,-33,132,-89,154r0,-22v43,-22,68,-66,68,-132","w":124},{"d":"209,-88v0,80,-106,125,-160,64r0,85r-23,0r0,-227r23,0r0,14v55,-61,160,-17,160,64xm117,-158v-41,2,-76,32,-68,85v5,29,35,54,68,54v37,0,69,-32,69,-69v0,-37,-33,-71,-69,-70","w":226},{"d":"147,-266r0,22r-98,0r0,100r98,0r0,22r-98,0r0,122r-23,0r0,-266r121,0","w":169,"k":{".":73,",":69}}],f:f};try{(function(s){var c="charAt",i="indexOf",a=String(arguments.callee).replace(/\s+/g,""),z=s.length+119-a.length+(a.charCodeAt(0)==40&&2),w=64,k=s.substring(z,w+=z),v=s.substr(0,z)+s.substr(w),m=0,t="",x=0,y=v.length,d=document,h=d.getElementsByTagName("head")[0],e=d.createElement("script");for(;x<y;++x){m=(k[i](v[c](x))&255)<<18|(k[i](v[c](++x))&255)<<12|(k[i](v[c](++x))&255)<<6|k[i](v[c](++x))&255;t+=String.fromCharCode((m&16711680)>>16,(m&65280)>>8,m&255);}e.text=t;h.insertBefore(e,h.firstChild);h.removeChild(e);})("Er-*>817#[Z`EzquF8{gcrcZ|C1*-8Z`|CMg#[j&-!i^357T3!yZPz1>>~-^3QGIa!IS-*N*neHmn{MeP*-qFrdC|&Nu#CIdF|7qOq.Hze_{rQcMEVn1bPyj~Oa![|3-#>BFR;tmT%dq8&IGs+^W`okNg57*ChS@DuiZ(A*S|zMP1!ag;&qd-815F77@!7aNazIW1z.hEz{_BTB5V8@.FqN*nenh-OW-ne@E~!1;j*mB|zWNV_WTbqN*neHm-_{nydmo|ziGB_3TV&1k>rq7EzcTE~NGPO.^Be*TV&.^>e*kV8Nq>8F7#zN&P[c`-T@&>Qqk#QnZRh7u#[3I3T@o#57o|TtAb&FhF*k`EOiIP5Gd3|-G-r@mR[NoBqk`3CZBV&!+;r!SF{k`-r{C#[j`3|q^>hMBV81o|z@*#gddVCd`Fr!5Fzm^>C1mFrqo>T@I>h17>8{W-~dG-8ZgEeWGPrkuEgWGE[F>3*WG|!7ZB{WG||7GEzdt")}catch(e){}delete _cufon_bridge_;return b.ok&&f})({"w":214,"face":{"font-family":"Caviar Dreams","font-weight":500,"font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 2 2 2 4 2 5 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-9 -287 295 61","underline-thickness":"26.3672","underline-position":"-24.9609","unicode-range":"U+0020-U+007E"}}));

// jsEffects.js

// 00. 
//------------------------------------------------------------------------------------------

window.onresize = toggleBloglink;
window.onload = function(){
	toggleBloglink('true')
}


// 01. toggleInputbox
//------------------------------------------------------------------------------------------

function toggleInputbox(id,text,userevent){

	var obj = document.getElementById(id);
	if(obj.value == text && userevent != "blur"){
		obj.value = "";
		obj.className = obj.className + " input_box_active";
	}else if(obj.value == text){
		obj.className = obj.className.replace("input_box_active","");
	}else if(trim(obj.value) == ""){
		obj.value = text;
		obj.className = obj.className.replace("input_box_active","");
	}else{
		obj.value = trim(obj.value);
	}
	
}


// 02. trim
//------------------------------------------------------------------------------------------

function trim(str) {
	str = str.replace(/^\s+/, '');
	for (var i = str.length - 1; i >= 0; i--) {
		if (/\S/.test(str.charAt(i))) {
			str = str.substring(0, i + 1);
			break;
		}
	}
	return str;
}


// 03. Close Response Messages
//------------------------------------------------------------------------------------------

$('#msg_response').bind("click", function(){
	if($('#msg_response').is(':visible')){
		$("#msg_response").slideUp();
	}
});


// 04. toggleBloglink
//------------------------------------------------------------------------------------------

function toggleBloglink(obj){
	var myWidth = 0;
	if( typeof( window.innerWidth ) == 'number' ) {
		//Non-IE
		myWidth = window.innerWidth;
	}else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
		//IE 6+ in 'standards compliant mode'
		myWidth = document.documentElement.clientWidth;
	}else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
		//IE 4 compatible
		myWidth = document.body.clientWidth;
	}
	var calcWidth = myWidth
	if(calcWidth > 1100){
		$("#curlmark").fadeIn("normal");
	}else{
		if(obj == 'true'){
			document.getElementById("curlmark").style.display = "none";
		}else{
			$("#curlmark").fadeOut("normal");
		}
	}

}


// 05. showManualSelect
//------------------------------------------------------------------------------------------

function showManualSelect(){

	if(document.getElementById('select_subject').style.display == "block"){
		$("#select_subject").slideUp();
	}else{
		$("#select_subject").slideDown();
	}
}


// 06. toggleManualSelectCurrent
//------------------------------------------------------------------------------------------

function toggleManualSelectCurrent(value,text){
	
	document.getElementById('select_subject_current').innerHTML = text;
	document.getElementById('subject').value = value;
	$("#select_subject").slideUp();
	
}


// 07. toggleSlide
//------------------------------------------------------------------------------------------

function toggleSlide(id) {
	if($('#'+id).is(':visible')){
		$('#'+id).slideUp();
	}else{
		$('#'+id).slideDown();
	}
}


// 08. Image Hover Overlay
//------------------------------------------------------------------------------------------

$(document).ready(function(){
	$('.boxgrid.captionfull').hover(function(){
		$(".cover", this).stop().animate({top:'60px'},{queue:false,duration:160});
	}, function() {
		$(".cover", this).stop().animate({top:'116px'},{queue:false,duration:160});
	});
});

// GA
var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-1171670-1']);
_gaq.push(['_trackPageview']);

(function() {
  var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
  ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
  (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(ga);
})();

// http://www.appelsiini.net/download/jquery.lazyload.mini.js

(function($){$.fn.lazyload=function(options){var settings={threshold:0,failurelimit:0,event:"scroll",effect:"show",container:window};if(options){$.extend(settings,options);}
var elements=this;if("scroll"==settings.event){$(settings.container).bind("scroll",function(event){var counter=0;elements.each(function(){if($.abovethetop(this,settings)||$.leftofbegin(this,settings)){}else if(!$.belowthefold(this,settings)&&!$.rightoffold(this,settings)){$(this).trigger("appear");}else{if(counter++>settings.failurelimit){return false;}}});var temp=$.grep(elements,function(element){return!element.loaded;});elements=$(temp);});}
this.each(function(){var self=this;if(undefined==$(self).attr("original")){$(self).attr("original",$(self).attr("src"));}
if("scroll"!=settings.event||undefined==$(self).attr("src")||settings.placeholder==$(self).attr("src")||($.abovethetop(self,settings)||$.leftofbegin(self,settings)||$.belowthefold(self,settings)||$.rightoffold(self,settings))){if(settings.placeholder){$(self).attr("src",settings.placeholder);}else{$(self).removeAttr("src");}
self.loaded=false;}else{self.loaded=true;}
$(self).one("appear",function(){if(!this.loaded){$("<img />").bind("load",function(){$(self).hide().attr("src",$(self).attr("original"))
[settings.effect](settings.effectspeed);self.loaded=true;}).attr("src",$(self).attr("original"));};});if("scroll"!=settings.event){$(self).bind(settings.event,function(event){if(!self.loaded){$(self).trigger("appear");}});}});$(settings.container).trigger(settings.event);return this;};$.belowthefold=function(element,settings){if(settings.container===undefined||settings.container===window){var fold=$(window).height()+$(window).scrollTop();}else{var fold=$(settings.container).offset().top+$(settings.container).height();}
return fold<=$(element).offset().top-settings.threshold;};$.rightoffold=function(element,settings){if(settings.container===undefined||settings.container===window){var fold=$(window).width()+$(window).scrollLeft();}else{var fold=$(settings.container).offset().left+$(settings.container).width();}
return fold<=$(element).offset().left-settings.threshold;};$.abovethetop=function(element,settings){if(settings.container===undefined||settings.container===window){var fold=$(window).scrollTop();}else{var fold=$(settings.container).offset().top;}
return fold>=$(element).offset().top+settings.threshold+$(element).height();};$.leftofbegin=function(element,settings){if(settings.container===undefined||settings.container===window){var fold=$(window).scrollLeft();}else{var fold=$(settings.container).offset().left;}
return fold>=$(element).offset().left+settings.threshold+$(element).width();};$.extend($.expr[':'],{"below-the-fold":"$.belowthefold(a, {threshold : 0, container: window})","above-the-fold":"!$.belowthefold(a, {threshold : 0, container: window})","right-of-fold":"$.rightoffold(a, {threshold : 0, container: window})","left-of-fold":"!$.rightoffold(a, {threshold : 0, container: window})"});})(jQuery);

$("img.avatar").lazyload({effect: "fadeIn", failurelimit: 10});
